<?php
/**
 * Plugin Name: Respira for WordPress
 * Plugin URI: https://respira.press
 * Description: Vibe code your WordPress site. No SSH required. Connect AI coding assistants like Cursor and Claude Code to edit your WordPress site through a secure REST API.
 * Version: 1.8.11
 * Author: Respira
 * Author URI: https://respira.press
 * License: GPL v2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain: respira-for-wordpress
 * Domain Path: /languages
 * Requires at least: 5.8
 * Requires PHP: 7.4
 *
 * @package Respira_For_WordPress
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

/**
 * Current plugin version.
 */
define( 'RESPIRA_VERSION', '1.8.11' );

/**
 * Plugin directory path.
 */
define( 'RESPIRA_PLUGIN_DIR', plugin_dir_path( __FILE__ ) );

/**
 * Plugin directory URL.
 */
define( 'RESPIRA_PLUGIN_URL', plugin_dir_url( __FILE__ ) );

/**
 * Plugin basename.
 */
define( 'RESPIRA_PLUGIN_BASENAME', plugin_basename( __FILE__ ) );

/**
 * REST API namespace.
 */
define( 'RESPIRA_REST_NAMESPACE', 'respira/v1' );

/**
 * Sentry DSN for error tracking (optional).
 * Set via wp-config.php or environment variable.
 */
if ( ! defined( 'RESPIRA_SENTRY_DSN' ) ) {
	define( 'RESPIRA_SENTRY_DSN', getenv( 'RESPIRA_SENTRY_DSN' ) ?: '' );
}

/**
 * The code that runs during plugin activation.
 */
function activate_respira_for_wordpress() {
	require_once RESPIRA_PLUGIN_DIR . 'includes/class-respira-activator.php';
	Respira_Activator::activate();
}

/**
 * The code that runs during plugin deactivation.
 */
function deactivate_respira_for_wordpress() {
	require_once RESPIRA_PLUGIN_DIR . 'includes/class-respira-deactivator.php';
	Respira_Deactivator::deactivate();
}

register_activation_hook( __FILE__, 'activate_respira_for_wordpress' );
register_deactivation_hook( __FILE__, 'deactivate_respira_for_wordpress' );

/**
 * Load Composer autoloader for dependencies (Sentry SDK).
 */
if ( file_exists( RESPIRA_PLUGIN_DIR . 'vendor/autoload.php' ) ) {
	require_once RESPIRA_PLUGIN_DIR . 'vendor/autoload.php';
}

/**
 * Initialize Sentry error tracking.
 */
require_once RESPIRA_PLUGIN_DIR . 'includes/class-respira-sentry.php';
Respira_Sentry::get_instance();

/**
 * The core plugin class.
 */
require RESPIRA_PLUGIN_DIR . 'includes/class-respira-core.php';

/**
 * Begins execution of the plugin.
 *
 * @since 1.0.0
 */
function run_respira_for_wordpress() {
	$plugin = new Respira_Core();
	$plugin->run();
}

run_respira_for_wordpress();
