<?php
/**
 * Visual Composer layout patterns library.
 *
 * Common layout patterns for Visual Composer shortcodes.
 *
 * @package    Respira_For_WordPress
 * @subpackage Respira_For_WordPress/includes/page-builders/visual-composer-intelligence
 * @since      1.4.0
 */

/**
 * Get Visual Composer layout patterns.
 *
 * @since  1.4.0
 * @return array Array of patterns.
 */
function respira_get_visual_composer_patterns() {
	return array(
		'hero-section'          => array(
			'title'       => __( 'Hero Section', 'respira-for-wordpress' ),
			'description' => __( 'Full-width hero section with heading and CTA button', 'respira-for-wordpress' ),
			'category'    => 'headers',
			'shortcode'   => '[vc_row full_width="stretch_row" css=".vc_custom_{background-color: #0066cc !important;padding-top: 80px !important;padding-bottom: 80px !important;}"][vc_column][vc_custom_heading text="' . esc_attr__( 'Welcome to Our Amazing Service', 'respira-for-wordpress' ) . '" font_container="tag:h1|font_size:48|text_align:center|color:%23ffffff" use_theme_fonts="yes"][vc_empty_space height="20px"][vc_column_text]
<p style="text-align: center; color: #ffffff; font-size: 18px;">' . __( 'Your compelling tagline goes here', 'respira-for-wordpress' ) . '</p>
[/vc_column_text][vc_empty_space height="30px"][vc_btn title="' . esc_attr__( 'Get Started', 'respira-for-wordpress' ) . '" style="flat" color="white" size="lg" align="center" link="url:%23|title:Get%20Started"][/vc_column][/vc_row]',
		),
		'three-column-features' => array(
			'title'       => __( 'Three Column Features', 'respira-for-wordpress' ),
			'description' => __( 'Three-column layout with icon and text features', 'respira-for-wordpress' ),
			'category'    => 'content',
			'shortcode'   => '[vc_row css=".vc_custom_{padding-top: 60px !important;padding-bottom: 60px !important;}"][vc_column width="1/3"][vc_icon type="fontawesome" icon_fontawesome="fa fa-chart-bar" color="custom" size="xl" align="center" custom_color="#0066cc"][vc_empty_space height="15px"][vc_column_text]
<h3 style="text-align: center;">' . __( 'Feature One', 'respira-for-wordpress' ) . '</h3>
<p style="text-align: center;">' . __( 'Description of your first amazing feature.', 'respira-for-wordpress' ) . '</p>
[/vc_column_text][/vc_column][vc_column width="1/3"][vc_icon type="fontawesome" icon_fontawesome="fa fa-chart-pie" color="custom" size="xl" align="center" custom_color="#0066cc"][vc_empty_space height="15px"][vc_column_text]
<h3 style="text-align: center;">' . __( 'Feature Two', 'respira-for-wordpress' ) . '</h3>
<p style="text-align: center;">' . __( 'Description of your second amazing feature.', 'respira-for-wordpress' ) . '</p>
[/vc_column_text][/vc_column][vc_column width="1/3"][vc_icon type="fontawesome" icon_fontawesome="fa fa-lightbulb" color="custom" size="xl" align="center" custom_color="#0066cc"][vc_empty_space height="15px"][vc_column_text]
<h3 style="text-align: center;">' . __( 'Feature Three', 'respira-for-wordpress' ) . '</h3>
<p style="text-align: center;">' . __( 'Description of your third amazing feature.', 'respira-for-wordpress' ) . '</p>
[/vc_column_text][/vc_column][/vc_row]',
		),
		'call-to-action'        => array(
			'title'       => __( 'Call to Action', 'respira-for-wordpress' ),
			'description' => __( 'Centered CTA section with heading and button', 'respira-for-wordpress' ),
			'category'    => 'cta',
			'shortcode'   => '[vc_row css=".vc_custom_{background-color: #f5f5f5 !important;padding-top: 60px !important;padding-bottom: 60px !important;}"][vc_column][vc_custom_heading text="' . esc_attr__( 'Ready to Get Started?', 'respira-for-wordpress' ) . '" font_container="tag:h2|font_size:36|text_align:center" use_theme_fonts="yes"][vc_empty_space height="15px"][vc_column_text]
<p style="text-align: center; font-size: 16px;">' . __( 'Join thousands of satisfied customers today', 'respira-for-wordpress' ) . '</p>
[/vc_column_text][vc_empty_space height="25px"][vc_btn title="' . esc_attr__( 'Sign Up Now', 'respira-for-wordpress' ) . '" style="flat" color="primary" size="lg" align="center" link="url:%23|title:Sign%20Up%20Now"][/vc_column][/vc_row]',
		),
		'two-column-content'    => array(
			'title'       => __( 'Two Column Content', 'respira-for-wordpress' ),
			'description' => __( 'Two-column layout with image and text', 'respira-for-wordpress' ),
			'category'    => 'content',
			'shortcode'   => '[vc_row css=".vc_custom_{padding-top: 60px !important;padding-bottom: 60px !important;}"][vc_column width="1/2"][vc_single_image image="" img_size="large" alignment="center"][/vc_column][vc_column width="1/2"][vc_custom_heading text="' . esc_attr__( 'About Our Service', 'respira-for-wordpress' ) . '" font_container="tag:h2|font_size:32" use_theme_fonts="yes"][vc_column_text]
<p>' . __( 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.', 'respira-for-wordpress' ) . '</p>
<p>' . __( 'Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris.', 'respira-for-wordpress' ) . '</p>
[/vc_column_text][vc_empty_space height="20px"][vc_btn title="' . esc_attr__( 'Learn More', 'respira-for-wordpress' ) . '" style="flat" color="primary" size="md" link="url:%23|title:Learn%20More"][/vc_column][/vc_row]',
		),
		'testimonial'           => array(
			'title'       => __( 'Testimonial', 'respira-for-wordpress' ),
			'description' => __( 'Centered testimonial with quote and author', 'respira-for-wordpress' ),
			'category'    => 'testimonials',
			'shortcode'   => '[vc_row css=".vc_custom_{background-color: #f9f9f9 !important;padding-top: 60px !important;padding-bottom: 60px !important;}"][vc_column][vc_icon type="fontawesome" icon_fontawesome="fa fa-quote-left" color="custom" size="lg" align="center" custom_color="#0066cc"][vc_empty_space height="20px"][vc_column_text]
<p style="text-align: center; font-size: 18px; font-style: italic;">' . __( '"This service has completely transformed the way we do business. Highly recommended!"', 'respira-for-wordpress' ) . '</p>
[/vc_column_text][vc_empty_space height="15px"][vc_column_text]
<p style="text-align: center; font-weight: bold;">' . __( 'Jane Doe', 'respira-for-wordpress' ) . '</p>
<p style="text-align: center;">' . __( 'CEO, Example Company', 'respira-for-wordpress' ) . '</p>
[/vc_column_text][/vc_column][/vc_row]',
		),
		'pricing-table'         => array(
			'title'       => __( 'Pricing Table', 'respira-for-wordpress' ),
			'description' => __( 'Three-column pricing comparison', 'respira-for-wordpress' ),
			'category'    => 'pricing',
			'shortcode'   => '[vc_row css=".vc_custom_{padding-top: 60px !important;padding-bottom: 60px !important;}"][vc_column width="1/3"][vc_column_text]
<h3 style="text-align: center;">' . __( 'Basic', 'respira-for-wordpress' ) . '</h3>
<p style="text-align: center; font-size: 36px; font-weight: bold;">$9<span style="font-size: 16px;">/mo</span></p>
[/vc_column_text][vc_separator color="grey"][vc_column_text]
<ul>
<li>' . __( 'Feature 1', 'respira-for-wordpress' ) . '</li>
<li>' . __( 'Feature 2', 'respira-for-wordpress' ) . '</li>
<li>' . __( 'Feature 3', 'respira-for-wordpress' ) . '</li>
</ul>
[/vc_column_text][vc_btn title="' . esc_attr__( 'Choose Plan', 'respira-for-wordpress' ) . '" style="flat" color="primary" align="center" link="url:%23|title:Choose%20Plan"][/vc_column][vc_column width="1/3" css=".vc_custom_{background-color: #0066cc !important;padding: 20px !important;}"][vc_column_text]
<h3 style="text-align: center; color: #ffffff;">' . __( 'Pro', 'respira-for-wordpress' ) . '</h3>
<p style="text-align: center; font-size: 36px; font-weight: bold; color: #ffffff;">$29<span style="font-size: 16px;">/mo</span></p>
[/vc_column_text][vc_separator color="white"][vc_column_text]
<ul style="color: #ffffff;">
<li>' . __( 'All Basic features', 'respira-for-wordpress' ) . '</li>
<li>' . __( 'Feature 4', 'respira-for-wordpress' ) . '</li>
<li>' . __( 'Feature 5', 'respira-for-wordpress' ) . '</li>
</ul>
[/vc_column_text][vc_btn title="' . esc_attr__( 'Choose Plan', 'respira-for-wordpress' ) . '" style="flat" color="white" align="center" link="url:%23|title:Choose%20Plan"][/vc_column][vc_column width="1/3"][vc_column_text]
<h3 style="text-align: center;">' . __( 'Enterprise', 'respira-for-wordpress' ) . '</h3>
<p style="text-align: center; font-size: 36px; font-weight: bold;">$99<span style="font-size: 16px;">/mo</span></p>
[/vc_column_text][vc_separator color="grey"][vc_column_text]
<ul>
<li>' . __( 'All Pro features', 'respira-for-wordpress' ) . '</li>
<li>' . __( 'Feature 6', 'respira-for-wordpress' ) . '</li>
<li>' . __( 'Feature 7', 'respira-for-wordpress' ) . '</li>
</ul>
[/vc_column_text][vc_btn title="' . esc_attr__( 'Contact Us', 'respira-for-wordpress' ) . '" style="flat" color="primary" align="center" link="url:%23|title:Contact%20Us"][/vc_column][/vc_row]',
		),
		'tabs-section'          => array(
			'title'       => __( 'Tabs Section', 'respira-for-wordpress' ),
			'description' => __( 'Tabbed content section', 'respira-for-wordpress' ),
			'category'    => 'content',
			'shortcode'   => '[vc_row css=".vc_custom_{padding-top: 40px !important;padding-bottom: 40px !important;}"][vc_column][vc_tabs][vc_tab title="' . esc_attr__( 'Tab One', 'respira-for-wordpress' ) . '" tab_id=""][vc_column_text]' . __( 'Content for tab one goes here.', 'respira-for-wordpress' ) . '[/vc_column_text][/vc_tab][vc_tab title="' . esc_attr__( 'Tab Two', 'respira-for-wordpress' ) . '" tab_id=""][vc_column_text]' . __( 'Content for tab two goes here.', 'respira-for-wordpress' ) . '[/vc_column_text][/vc_tab][vc_tab title="' . esc_attr__( 'Tab Three', 'respira-for-wordpress' ) . '" tab_id=""][vc_column_text]' . __( 'Content for tab three goes here.', 'respira-for-wordpress' ) . '[/vc_column_text][/vc_tab][/vc_tabs][/vc_column][/vc_row]',
		),
		'accordion-section'     => array(
			'title'       => __( 'Accordion Section', 'respira-for-wordpress' ),
			'description' => __( 'Collapsible accordion content', 'respira-for-wordpress' ),
			'category'    => 'content',
			'shortcode'   => '[vc_row css=".vc_custom_{padding-top: 40px !important;padding-bottom: 40px !important;}"][vc_column][vc_accordion][vc_accordion_tab title="' . esc_attr__( 'Question One', 'respira-for-wordpress' ) . '"][vc_column_text]' . __( 'Answer to question one goes here.', 'respira-for-wordpress' ) . '[/vc_column_text][/vc_accordion_tab][vc_accordion_tab title="' . esc_attr__( 'Question Two', 'respira-for-wordpress' ) . '"][vc_column_text]' . __( 'Answer to question two goes here.', 'respira-for-wordpress' ) . '[/vc_column_text][/vc_accordion_tab][vc_accordion_tab title="' . esc_attr__( 'Question Three', 'respira-for-wordpress' ) . '"][vc_column_text]' . __( 'Answer to question three goes here.', 'respira-for-wordpress' ) . '[/vc_column_text][/vc_accordion_tab][/vc_accordion][/vc_column][/vc_row]',
		),
	);
}
