<?php
/**
 * Visual Composer Intelligence Loader.
 *
 * Loads Visual Composer Intelligence addon if available.
 *
 * @package    Respira_For_WordPress
 * @subpackage Respira_For_WordPress/includes/page-builders/visual-composer-intelligence
 * @since      1.4.0
 */

/**
 * Visual Composer Intelligence loader class.
 *
 * @since 1.4.0
 */
class Respira_Visual_Composer_Intelligence_Loader {

	/**
	 * Check if Visual Composer Intelligence is available.
	 *
	 * @since 1.4.0
	 * @return bool True if Visual Composer Intelligence is available.
	 */
	public static function is_available() {
		$loader_file = RESPIRA_PLUGIN_DIR . 'includes/visual-composer-intelligence/class-visual-composer-intelligence-loader.php';
		return file_exists( $loader_file );
	}

	/**
	 * Load Visual Composer Intelligence.
	 *
	 * @since 1.4.0
	 * @return void
	 */
	public static function load() {
		$intelligence_dir = RESPIRA_PLUGIN_DIR . 'includes/visual-composer-intelligence/';

		// Load core Visual Composer Intelligence classes.
		$classes = array(
			'class-visual-composer-element-registry.php',
			'class-visual-composer-element-schema.php',
			'class-visual-composer-validator.php',
		);

		foreach ( $classes as $class_file ) {
			$file_path = $intelligence_dir . $class_file;
			if ( file_exists( $file_path ) ) {
				require_once $file_path;
			}
		}

		// Load data files.
		$data_files = array(
			'visual-composer-patterns.php',
		);

		foreach ( $data_files as $data_file ) {
			$file_path = $intelligence_dir . $data_file;
			if ( file_exists( $file_path ) ) {
				require_once $file_path;
			}
		}
	}
}
