<?php
/**
 * Thrive Architect layout patterns library.
 *
 * Conversion-focused layout patterns for Thrive Architect elements.
 *
 * @package    Respira_For_WordPress
 * @subpackage Respira_For_WordPress/includes/page-builders/thrive-intelligence
 * @since      1.4.0
 */

/**
 * Get Thrive Architect layout patterns.
 *
 * @since  1.4.0
 * @return array Array of patterns.
 */
function respira_get_thrive_patterns() {
	return array(
		'lead-generation-hero'    => array(
			'title'       => __( 'Lead Generation Hero', 'respira-for-wordpress' ),
			'description' => __( 'Hero section with headline and lead capture form', 'respira-for-wordpress' ),
			'category'    => 'lead-generation',
			'structure'   => array(
				array(
					'type'       => 'section',
					'properties' => array(
						'background' => array(
							'color' => '#0066CC',
							'image' => '',
						),
						'padding'    => array(
							'top'    => '80px',
							'bottom' => '80px',
						),
					),
					'children'   => array(
						array(
							'type'       => 'column',
							'properties' => array(
								'width' => '100%',
							),
							'children'   => array(
								array(
									'type'       => 'heading',
									'properties' => array(
										'text'      => __( 'Get Your Free Guide Now', 'respira-for-wordpress' ),
										'tag'       => 'h1',
										'color'     => '#FFFFFF',
										'alignment' => 'center',
									),
								),
								array(
									'type'       => 'paragraph',
									'properties' => array(
										'content'   => __( 'Join thousands who have already downloaded our comprehensive guide to success', 'respira-for-wordpress' ),
										'color'     => '#FFFFFF',
										'alignment' => 'center',
									),
								),
								array(
									'type'       => 'lead_generation',
									'properties' => array(
										'fields'          => array(
											array(
												'type'        => 'text',
												'label'       => __( 'First Name', 'respira-for-wordpress' ),
												'placeholder' => __( 'Enter your first name', 'respira-for-wordpress' ),
												'required'    => true,
											),
											array(
												'type'        => 'email',
												'label'       => __( 'Email Address', 'respira-for-wordpress' ),
												'placeholder' => __( 'Enter your email', 'respira-for-wordpress' ),
												'required'    => true,
											),
										),
										'submit_text'     => __( 'Download Free Guide', 'respira-for-wordpress' ),
										'success_message' => __( 'Thank you! Check your email for the download link.', 'respira-for-wordpress' ),
										'style'           => 'primary',
									),
								),
							),
						),
					),
				),
			),
		),

		'countdown-cta'           => array(
			'title'       => __( 'Countdown Call to Action', 'respira-for-wordpress' ),
			'description' => __( 'Urgency-driven CTA with countdown timer', 'respira-for-wordpress' ),
			'category'    => 'conversion',
			'structure'   => array(
				array(
					'type'       => 'section',
					'properties' => array(
						'background' => array(
							'color' => '#FF6B35',
						),
						'padding'    => array(
							'top'    => '60px',
							'bottom' => '60px',
						),
					),
					'children'   => array(
						array(
							'type'       => 'column',
							'properties' => array(
								'width' => '100%',
							),
							'children'   => array(
								array(
									'type'       => 'heading',
									'properties' => array(
										'text'      => __( 'Limited Time Offer!', 'respira-for-wordpress' ),
										'tag'       => 'h2',
										'color'     => '#FFFFFF',
										'alignment' => 'center',
									),
								),
								array(
									'type'       => 'countdown',
									'properties' => array(
										'date'     => gmdate( 'Y-m-d H:i:s', strtotime( '+7 days' ) ),
										'timezone' => 'America/New_York',
										'format'   => 'days_hours_minutes',
										'action'   => 'hide',
									),
								),
								array(
									'type'       => 'paragraph',
									'properties' => array(
										'content'   => __( 'This exclusive offer expires soon. Don\'t miss out!', 'respira-for-wordpress' ),
										'color'     => '#FFFFFF',
										'alignment' => 'center',
									),
								),
								array(
									'type'       => 'button',
									'properties' => array(
										'text'  => __( 'Claim Your Discount Now', 'respira-for-wordpress' ),
										'url'   => '#',
										'style' => 'primary',
										'size'  => 'large',
										'color' => '#FFFFFF',
									),
								),
							),
						),
					),
				),
			),
		),

		'two-step-optin'          => array(
			'title'       => __( 'Two-Step Opt-in', 'respira-for-wordpress' ),
			'description' => __( 'Content preview with opt-in form to access full content', 'respira-for-wordpress' ),
			'category'    => 'lead-generation',
			'structure'   => array(
				array(
					'type'       => 'section',
					'properties' => array(
						'background' => array(
							'color' => '#F8F9FA',
						),
						'padding'    => array(
							'top'    => '60px',
							'bottom' => '60px',
						),
					),
					'children'   => array(
						array(
							'type'       => 'column',
							'properties' => array(
								'width' => '60%',
							),
							'children'   => array(
								array(
									'type'       => 'heading',
									'properties' => array(
										'text' => __( '7 Secrets to Boost Your Conversion Rate', 'respira-for-wordpress' ),
										'tag'  => 'h2',
									),
								),
								array(
									'type'       => 'paragraph',
									'properties' => array(
										'content' => __( 'Secret #1: Use compelling headlines that grab attention...<br><br>Secret #2: Create urgency with limited-time offers...<br><br>Secret #3: Social proof builds trust...', 'respira-for-wordpress' ),
									),
								),
								array(
									'type'       => 'contentbox',
									'properties' => array(
										'background' => array(
											'color' => '#FFFFFF',
										),
										'border'     => array(
											'width' => '2px',
											'style' => 'solid',
											'color' => '#0066CC',
										),
										'padding'    => array(
											'top'    => '30px',
											'right'  => '30px',
											'bottom' => '30px',
											'left'   => '30px',
										),
									),
									'children'   => array(
										array(
											'type'       => 'heading',
											'properties' => array(
												'text'      => __( 'Want to See All 7 Secrets?', 'respira-for-wordpress' ),
												'tag'       => 'h3',
												'alignment' => 'center',
											),
										),
										array(
											'type'       => 'optin',
											'properties' => array(
												'fields'      => array(
													array(
														'type'     => 'email',
														'label'    => __( 'Email Address', 'respira-for-wordpress' ),
														'required' => true,
													),
												),
												'submit_text' => __( 'Show Me The Secrets', 'respira-for-wordpress' ),
												'success_url' => '/full-content',
											),
										),
									),
								),
							),
						),
					),
				),
			),
		),

		'testimonial-social-proof' => array(
			'title'       => __( 'Testimonial with Social Proof', 'respira-for-wordpress' ),
			'description' => __( 'Customer testimonial with star rating and social share', 'respira-for-wordpress' ),
			'category'    => 'social-proof',
			'structure'   => array(
				array(
					'type'       => 'section',
					'properties' => array(
						'background' => array(
							'color' => '#FFFFFF',
						),
						'padding'    => array(
							'top'    => '60px',
							'bottom' => '60px',
						),
					),
					'children'   => array(
						array(
							'type'       => 'column',
							'properties' => array(
								'width' => '100%',
							),
							'children'   => array(
								array(
									'type'       => 'star_rating',
									'properties' => array(
										'rating' => 5,
										'max'    => 5,
										'color'  => '#FFB800',
									),
								),
								array(
									'type'       => 'testimonial',
									'properties' => array(
										'content' => __( 'This product completely transformed my business. Within just 30 days, I saw a 150% increase in conversions. Absolutely incredible!', 'respira-for-wordpress' ),
										'author'  => __( 'Sarah Johnson', 'respira-for-wordpress' ),
										'role'    => __( 'Marketing Director, Tech Startup', 'respira-for-wordpress' ),
										'image'   => 'https://via.placeholder.com/100x100',
									),
								),
								array(
									'type'       => 'social_share',
									'properties' => array(
										'networks' => array( 'facebook', 'twitter', 'linkedin' ),
										'style'    => 'rounded',
										'size'     => 'medium',
									),
								),
							),
						),
					),
				),
			),
		),

		'pricing-comparison'      => array(
			'title'       => __( 'Pricing Comparison Table', 'respira-for-wordpress' ),
			'description' => __( 'Three-tier pricing with feature comparison', 'respira-for-wordpress' ),
			'category'    => 'pricing',
			'structure'   => array(
				array(
					'type'       => 'section',
					'properties' => array(
						'background' => array(
							'color' => '#F8F9FA',
						),
						'padding'    => array(
							'top'    => '80px',
							'bottom' => '80px',
						),
					),
					'children'   => array(
						array(
							'type'       => 'heading',
							'properties' => array(
								'text'      => __( 'Choose Your Plan', 'respira-for-wordpress' ),
								'tag'       => 'h2',
								'alignment' => 'center',
							),
						),
						array(
							'type'       => 'pricing_table',
							'properties' => array(
								'columns'  => array(
									array(
										'name'        => __( 'Starter', 'respira-for-wordpress' ),
										'price'       => '$29',
										'period'      => __( '/month', 'respira-for-wordpress' ),
										'description' => __( 'Perfect for beginners', 'respira-for-wordpress' ),
										'cta_text'    => __( 'Get Started', 'respira-for-wordpress' ),
										'cta_url'     => '#',
									),
									array(
										'name'        => __( 'Professional', 'respira-for-wordpress' ),
										'price'       => '$79',
										'period'      => __( '/month', 'respira-for-wordpress' ),
										'description' => __( 'For growing businesses', 'respira-for-wordpress' ),
										'cta_text'    => __( 'Go Pro', 'respira-for-wordpress' ),
										'cta_url'     => '#',
										'highlighted' => true,
									),
									array(
										'name'        => __( 'Enterprise', 'respira-for-wordpress' ),
										'price'       => '$199',
										'period'      => __( '/month', 'respira-for-wordpress' ),
										'description' => __( 'For large organizations', 'respira-for-wordpress' ),
										'cta_text'    => __( 'Contact Sales', 'respira-for-wordpress' ),
										'cta_url'     => '#',
									),
								),
								'features' => array(
									array(
										'name'    => __( 'Users', 'respira-for-wordpress' ),
										'starter' => '1',
										'pro'     => '5',
										'ent'     => __( 'Unlimited', 'respira-for-wordpress' ),
									),
									array(
										'name'    => __( 'Storage', 'respira-for-wordpress' ),
										'starter' => '10GB',
										'pro'     => '100GB',
										'ent'     => '1TB',
									),
									array(
										'name'    => __( 'Support', 'respira-for-wordpress' ),
										'starter' => __( 'Email', 'respira-for-wordpress' ),
										'pro'     => __( 'Priority', 'respira-for-wordpress' ),
										'ent'     => __( '24/7 Dedicated', 'respira-for-wordpress' ),
									),
								),
							),
						),
					),
				),
			),
		),

		'video-optin'             => array(
			'title'       => __( 'Video with Opt-in', 'respira-for-wordpress' ),
			'description' => __( 'Video presentation with email opt-in below', 'respira-for-wordpress' ),
			'category'    => 'lead-generation',
			'structure'   => array(
				array(
					'type'       => 'section',
					'properties' => array(
						'background' => array(
							'color' => '#FFFFFF',
						),
						'padding'    => array(
							'top'    => '60px',
							'bottom' => '60px',
						),
					),
					'children'   => array(
						array(
							'type'       => 'column',
							'properties' => array(
								'width' => '100%',
							),
							'children'   => array(
								array(
									'type'       => 'heading',
									'properties' => array(
										'text'      => __( 'Watch This Free Training Video', 'respira-for-wordpress' ),
										'tag'       => 'h2',
										'alignment' => 'center',
									),
								),
								array(
									'type'       => 'video',
									'properties' => array(
										'url'       => 'https://www.youtube.com/watch?v=dQw4w9WgXcQ',
										'type'      => 'youtube',
										'thumbnail' => 'https://via.placeholder.com/1280x720',
										'autoplay'  => false,
									),
								),
								array(
									'type'       => 'divider',
									'properties' => array(
										'style' => 'solid',
										'width' => '100%',
										'color' => '#E0E0E0',
									),
								),
								array(
									'type'       => 'heading',
									'properties' => array(
										'text'      => __( 'Want More Training Like This?', 'respira-for-wordpress' ),
										'tag'       => 'h3',
										'alignment' => 'center',
									),
								),
								array(
									'type'       => 'paragraph',
									'properties' => array(
										'content'   => __( 'Subscribe to receive exclusive video tutorials and tips directly to your inbox', 'respira-for-wordpress' ),
										'alignment' => 'center',
									),
								),
								array(
									'type'       => 'optin',
									'properties' => array(
										'fields'          => array(
											array(
												'type'     => 'email',
												'label'    => __( 'Email Address', 'respira-for-wordpress' ),
												'required' => true,
											),
										),
										'submit_text'     => __( 'Subscribe Now', 'respira-for-wordpress' ),
										'success_message' => __( 'Welcome! Check your email to confirm your subscription.', 'respira-for-wordpress' ),
									),
								),
							),
						),
					),
				),
			),
		),

		'feature-comparison-tabs' => array(
			'title'       => __( 'Feature Comparison Tabs', 'respira-for-wordpress' ),
			'description' => __( 'Tabbed content showing different product features', 'respira-for-wordpress' ),
			'category'    => 'content',
			'structure'   => array(
				array(
					'type'       => 'section',
					'properties' => array(
						'background' => array(
							'color' => '#FFFFFF',
						),
						'padding'    => array(
							'top'    => '60px',
							'bottom' => '60px',
						),
					),
					'children'   => array(
						array(
							'type'       => 'column',
							'properties' => array(
								'width' => '100%',
							),
							'children'   => array(
								array(
									'type'       => 'heading',
									'properties' => array(
										'text'      => __( 'Powerful Features That Drive Results', 'respira-for-wordpress' ),
										'tag'       => 'h2',
										'alignment' => 'center',
									),
								),
								array(
									'type'       => 'tabs',
									'properties' => array(
										'tabs'        => array(
											array(
												'title'   => __( 'Analytics', 'respira-for-wordpress' ),
												'content' => __( '<p>Track every metric that matters with our advanced analytics dashboard. See real-time conversions, user behavior, and revenue data all in one place.</p>', 'respira-for-wordpress' ),
											),
											array(
												'title'   => __( 'A/B Testing', 'respira-for-wordpress' ),
												'content' => __( '<p>Optimize your conversions with built-in A/B testing. Test headlines, images, CTAs, and more to find what works best for your audience.</p>', 'respira-for-wordpress' ),
											),
											array(
												'title'   => __( 'Integrations', 'respira-for-wordpress' ),
												'content' => __( '<p>Connect with all your favorite tools. Native integrations with MailChimp, Salesforce, HubSpot, and 100+ other platforms.</p>', 'respira-for-wordpress' ),
											),
										),
										'orientation' => 'horizontal',
										'style'       => 'primary',
									),
								),
								array(
									'type'       => 'button',
									'properties' => array(
										'text'  => __( 'See All Features', 'respira-for-wordpress' ),
										'url'   => '#',
										'style' => 'primary',
									),
								),
							),
						),
					),
				),
			),
		),

		'progress-bar-cta'        => array(
			'title'       => __( 'Progress Bar Call to Action', 'respira-for-wordpress' ),
			'description' => __( 'Visual progress indicator with conversion CTA', 'respira-for-wordpress' ),
			'category'    => 'conversion',
			'structure'   => array(
				array(
					'type'       => 'section',
					'properties' => array(
						'background' => array(
							'color' => '#F0F8FF',
						),
						'padding'    => array(
							'top'    => '60px',
							'bottom' => '60px',
						),
					),
					'children'   => array(
						array(
							'type'       => 'column',
							'properties' => array(
								'width' => '100%',
							),
							'children'   => array(
								array(
									'type'       => 'heading',
									'properties' => array(
										'text'      => __( 'You\'re 3 Steps Away from Success', 'respira-for-wordpress' ),
										'tag'       => 'h2',
										'alignment' => 'center',
									),
								),
								array(
									'type'       => 'progressbar',
									'properties' => array(
										'percentage' => 33,
										'color'      => '#0066CC',
										'animation'  => 'slide',
									),
								),
								array(
									'type'       => 'paragraph',
									'properties' => array(
										'content'   => __( '<strong>Step 1:</strong> Sign up for free (1 minute)<br><strong>Step 2:</strong> Customize your settings (2 minutes)<br><strong>Step 3:</strong> Launch your first campaign (3 minutes)', 'respira-for-wordpress' ),
										'alignment' => 'center',
									),
								),
								array(
									'type'       => 'button',
									'properties' => array(
										'text'  => __( 'Start Step 1 Now', 'respira-for-wordpress' ),
										'url'   => '#',
										'style' => 'primary',
										'size'  => 'large',
									),
								),
							),
						),
					),
				),
			),
		),
	);
}
