<?php
/**
 * Thrive Architect Intelligence Loader.
 *
 * Loads Thrive Architect Intelligence addon if available.
 *
 * @package    Respira_For_WordPress
 * @subpackage Respira_For_WordPress/includes/page-builders/thrive-intelligence
 * @since      1.4.0
 */

/**
 * Thrive Architect Intelligence loader class.
 *
 * @since 1.4.0
 */
class Respira_Thrive_Intelligence_Loader {

	/**
	 * Check if Thrive Architect Intelligence is available.
	 *
	 * @since 1.4.0
	 * @return bool True if Thrive Architect Intelligence is available.
	 */
	public static function is_available() {
		$loader_file = RESPIRA_PLUGIN_DIR . 'includes/thrive-intelligence/class-thrive-intelligence-loader.php';
		return file_exists( $loader_file );
	}

	/**
	 * Load Thrive Architect Intelligence.
	 *
	 * @since 1.4.0
	 * @return void
	 */
	public static function load() {
		$intelligence_dir = RESPIRA_PLUGIN_DIR . 'includes/thrive-intelligence/';

		// Load core Thrive Intelligence classes.
		$classes = array(
			'class-thrive-element-registry.php',
			'class-thrive-element-schema.php',
			'class-thrive-validator.php',
		);

		foreach ( $classes as $class_file ) {
			$file_path = $intelligence_dir . $class_file;
			if ( file_exists( $file_path ) ) {
				require_once $file_path;
			}
		}

		// Load data files.
		$data_files = array(
			'thrive-patterns.php',
		);

		foreach ( $data_files as $data_file ) {
			$file_path = $intelligence_dir . $data_file;
			if ( file_exists( $file_path ) ) {
				require_once $file_path;
			}
		}
	}
}
