<?php
/**
 * Oxygen Builder layout patterns library.
 *
 * Common layout patterns for Oxygen Builder components.
 *
 * @package    Respira_For_WordPress
 * @subpackage Respira_For_WordPress/includes/page-builders/oxygen-intelligence
 * @since      1.4.0
 */

/**
 * Get Oxygen Builder layout patterns.
 *
 * @since  1.4.0
 * @return array Array of patterns.
 */
function respira_get_oxygen_patterns() {
	return array(
		'hero-section'          => array(
			'title'       => __( 'Hero Section', 'respira-for-wordpress' ),
			'description' => __( 'Full-width hero section with heading and CTA button', 'respira-for-wordpress' ),
			'category'    => 'headers',
			'structure'   => array(
				'code' => wp_json_encode(
					array(
						array(
							'id'       => 'section_' . uniqid(),
							'name'     => 'ct_section',
							'options'  => array(
								'width'            => '100%',
								'background-color' => '#0066cc',
								'padding'          => '80px 20px',
							),
							'children' => array(
								array(
									'id'      => 'heading_' . uniqid(),
									'name'    => 'ct_headline',
									'options' => array(
										'ct_content'  => __( 'Welcome to Our Amazing Service', 'respira-for-wordpress' ),
										'tag'         => 'h1',
										'font-size'   => '48px',
										'color'       => '#ffffff',
										'text-align'  => 'center',
									),
								),
								array(
									'id'      => 'text_' . uniqid(),
									'name'    => 'ct_text_block',
									'options' => array(
										'ct_content' => '<p>' . __( 'Your compelling tagline goes here', 'respira-for-wordpress' ) . '</p>',
										'font-size'  => '18px',
										'color'      => '#ffffff',
										'text-align' => 'center',
										'margin'     => '20px 0 30px 0',
									),
								),
								array(
									'id'      => 'button_' . uniqid(),
									'name'    => 'ct_link_button',
									'options' => array(
										'ct_content'       => __( 'Get Started', 'respira-for-wordpress' ),
										'url'              => '#',
										'background-color' => '#ffffff',
										'color'            => '#0066cc',
										'padding'          => '15px 30px',
									),
								),
							),
						),
					)
				),
			),
		),
		'three-column-features' => array(
			'title'       => __( 'Three Column Features', 'respira-for-wordpress' ),
			'description' => __( 'Three-column layout with icon and text features', 'respira-for-wordpress' ),
			'category'    => 'content',
			'note'        => __( 'Use ct_new_columns with three ct_column children', 'respira-for-wordpress' ),
		),
		'call-to-action'        => array(
			'title'       => __( 'Call to Action', 'respira-for-wordpress' ),
			'description' => __( 'Centered CTA section with heading and button', 'respira-for-wordpress' ),
			'category'    => 'cta',
			'note'        => __( 'Section with centered content and button', 'respira-for-wordpress' ),
		),
		'testimonial'           => array(
			'title'       => __( 'Testimonial', 'respira-for-wordpress' ),
			'description' => __( 'Testimonial with quote', 'respira-for-wordpress' ),
			'category'    => 'testimonials',
			'note'        => __( 'Use oxy_testimonial component', 'respira-for-wordpress' ),
		),
		'pricing-table'         => array(
			'title'       => __( 'Pricing Table', 'respira-for-wordpress' ),
			'description' => __( 'Three-column pricing comparison', 'respira-for-wordpress' ),
			'category'    => 'pricing',
			'note'        => __( 'Use oxy_pricing_box components in columns layout', 'respira-for-wordpress' ),
		),
		'image-with-text'       => array(
			'title'       => __( 'Image with Text', 'respira-for-wordpress' ),
			'description' => __( 'Two-column layout with image and text', 'respira-for-wordpress' ),
			'category'    => 'content',
			'note'        => __( 'Use ct_new_columns with two columns: ct_image and ct_text_block', 'respira-for-wordpress' ),
		),
	);
}

/**
 * Generate a unique Oxygen component ID.
 *
 * @since  1.4.0
 * @param  string $prefix Optional prefix for the ID.
 * @return string Unique component ID.
 */
function respira_oxygen_generate_id( $prefix = 'component' ) {
	return $prefix . '_' . uniqid();
}

/**
 * Create an Oxygen component structure.
 *
 * @since  1.4.0
 * @param  string $name     Component name/type.
 * @param  array  $options  Component options.
 * @param  array  $children Optional child components.
 * @return array Component structure.
 */
function respira_oxygen_create_component( $name, $options = array(), $children = array() ) {
	$component = array(
		'id'      => respira_oxygen_generate_id( str_replace( 'ct_', '', $name ) ),
		'name'    => $name,
		'options' => $options,
	);

	if ( ! empty( $children ) ) {
		$component['children'] = $children;
	}

	return $component;
}
