<?php
/**
 * Elementor layout patterns library.
 *
 * Common layout patterns for Elementor widgets.
 *
 * @package    Respira_For_WordPress
 * @subpackage Respira_For_WordPress/includes/page-builders/elementor-intelligence
 * @since      1.3.0
 */

/**
 * Get Elementor layout patterns.
 *
 * @since  1.3.0
 * @return array Array of patterns.
 */
function respira_get_elementor_patterns() {
	return array(
		'hero-section' => array(
			'title'       => __( 'Hero Section', 'respira-for-wordpress' ),
			'description' => __( 'Full-width hero section with heading, text, and CTA button', 'respira-for-wordpress' ),
			'category'    => 'headers',
			'structure'   => array(
				array(
					'type'     => 'section',
					'settings' => array(
						'layout' => 'boxed',
					),
					'elements' => array(
						array(
							'type'     => 'column',
							'settings' => array(),
							'elements' => array(
								array(
									'type'     => 'widget',
									'widget'   => 'heading',
									'settings' => array(
										'title' => __( 'Welcome to Our Site', 'respira-for-wordpress' ),
										'size'  => 'xl',
									),
								),
								array(
									'type'     => 'widget',
									'widget'   => 'text-editor',
									'settings' => array(
										'editor' => __( 'Your compelling tagline here', 'respira-for-wordpress' ),
									),
								),
								array(
									'type'     => 'widget',
									'widget'   => 'button',
									'settings' => array(
										'text' => __( 'Get Started', 'respira-for-wordpress' ),
										'link' => array(
											'url' => '#',
										),
									),
								),
							),
						),
					),
				),
			),
		),
		'three-column-features' => array(
			'title'       => __( 'Three Column Features', 'respira-for-wordpress' ),
			'description' => __( 'Three-column layout with feature items', 'respira-for-wordpress' ),
			'category'    => 'content',
			'structure'   => array(
				array(
					'type'     => 'section',
					'settings' => array(),
					'elements' => array(
						array(
							'type'     => 'column',
							'settings' => array(),
							'elements' => array(
								array(
									'type'     => 'widget',
									'widget'   => 'heading',
									'settings' => array(
										'title' => __( 'Feature 1', 'respira-for-wordpress' ),
									),
								),
								array(
									'type'     => 'widget',
									'widget'   => 'text-editor',
									'settings' => array(
										'editor' => __( 'Feature description', 'respira-for-wordpress' ),
									),
								),
							),
						),
						array(
							'type'     => 'column',
							'settings' => array(),
							'elements' => array(
								array(
									'type'     => 'widget',
									'widget'   => 'heading',
									'settings' => array(
										'title' => __( 'Feature 2', 'respira-for-wordpress' ),
									),
								),
								array(
									'type'     => 'widget',
									'widget'   => 'text-editor',
									'settings' => array(
										'editor' => __( 'Feature description', 'respira-for-wordpress' ),
									),
								),
							),
						),
						array(
							'type'     => 'column',
							'settings' => array(),
							'elements' => array(
								array(
									'type'     => 'widget',
									'widget'   => 'heading',
									'settings' => array(
										'title' => __( 'Feature 3', 'respira-for-wordpress' ),
									),
								),
								array(
									'type'     => 'widget',
									'widget'   => 'text-editor',
									'settings' => array(
										'editor' => __( 'Feature description', 'respira-for-wordpress' ),
									),
								),
							),
						),
					),
				),
			),
		),
		'pricing-table' => array(
			'title'       => __( 'Pricing Table', 'respira-for-wordpress' ),
			'description' => __( 'Three-column pricing table layout', 'respira-for-wordpress' ),
			'category'    => 'content',
			'structure'   => array(
				array(
					'type'     => 'section',
					'settings' => array(),
					'elements' => array(
						array(
							'type'     => 'column',
							'settings' => array(),
							'elements' => array(
								array(
									'type'     => 'widget',
									'widget'   => 'heading',
									'settings' => array(
										'title' => __( 'Basic', 'respira-for-wordpress' ),
									),
								),
								array(
									'type'     => 'widget',
									'widget'   => 'text-editor',
									'settings' => array(
										'editor' => '$9/month',
									),
								),
								array(
									'type'     => 'widget',
									'widget'   => 'button',
									'settings' => array(
										'text' => __( 'Get Started', 'respira-for-wordpress' ),
									),
								),
							),
						),
					),
				),
			),
		),
	);
}

