<?php
/**
 * Elementor Intelligence Loader.
 *
 * Loads Elementor Intelligence addon if available.
 *
 * @package    Respira_For_WordPress
 * @subpackage Respira_For_WordPress/includes/page-builders/elementor-intelligence
 * @since      1.3.0
 */

/**
 * Elementor Intelligence loader class.
 *
 * @since 1.3.0
 */
class Respira_Elementor_Intelligence_Loader {

	/**
	 * Check if Elementor Intelligence is available.
	 *
	 * @since 1.3.0
	 * @return bool True if Elementor Intelligence is available.
	 */
	public static function is_available() {
		$loader_file = RESPIRA_PLUGIN_DIR . 'includes/elementor-intelligence/class-elementor-intelligence-loader.php';
		return file_exists( $loader_file );
	}

	/**
	 * Load Elementor Intelligence.
	 *
	 * @since 1.3.0
	 * @return void
	 */
	public static function load() {
		$intelligence_dir = RESPIRA_PLUGIN_DIR . 'includes/elementor-intelligence/';

		// Load core Elementor Intelligence classes.
		$classes = array(
			'class-elementor-widget-registry.php',
			'class-elementor-widget-schema.php',
			'class-elementor-validator.php',
		);

		foreach ( $classes as $class_file ) {
			$file_path = $intelligence_dir . $class_file;
			if ( file_exists( $file_path ) ) {
				require_once $file_path;
			}
		}

		// Load data files.
		$data_files = array(
			'elementor-patterns.php',
		);

		foreach ( $data_files as $data_file ) {
			$file_path = $intelligence_dir . $data_file;
			if ( file_exists( $file_path ) ) {
				require_once $file_path;
			}
		}
	}
}

