<?php
/**
 * Divi Intelligence - Module Definitions Data File.
 *
 * Comprehensive list of all Divi modules.
 * This file provides module definitions and schemas for the Divi builder integration.
 * Part of Divi Intelligence addon for Respira for WordPress.
 *
 * @package    Respira_For_WordPress
 * @subpackage Respira_For_WordPress/includes/divi-intelligence
 */

/**
 * Get Divi module definitions organized by tier.
 *
 * @since 1.0.0
 * @return array Array of module definitions.
 */
function respira_get_divi_module_definitions() {
	return array(
		// All Divi modules - full support (no tiers).
		array(
			'name'        => 'et_pb_section',
			'title'       => 'Section',
			'description' => 'Top-level container for rows and modules',
			'category'    => 'layout',
		),
		array(
			'name'        => 'et_pb_row',
			'title'       => 'Row',
			'description' => 'Column layout container',
			'category'    => 'layout',
		),
		array(
			'name'        => 'et_pb_text',
			'title'       => 'Text',
			'description' => 'Text content module for paragraphs and headings',
			'category'    => 'content',
		),
		array(
			'name'        => 'et_pb_image',
			'title'       => 'Image',
			'description' => 'Image module',
			'category'    => 'media',
		),
		array(
			'name'        => 'et_pb_button',
			'title'       => 'Button',
			'description' => 'Button module',
			'category'    => 'content',
		),
		array(
			'name'        => 'et_pb_cta',
			'title'       => 'Call to Action',
			'description' => 'Call to action module with heading, text, and button',
			'category'    => 'content',
		),
		array(
			'name'        => 'et_pb_blurb',
			'title'       => 'Blurb',
			'description' => 'Icon with text module',
			'category'    => 'content',
		),
		array(
			'name'        => 'et_pb_video',
			'title'       => 'Video',
			'description' => 'Video module',
			'category'    => 'media',
		),
		array(
			'name'        => 'et_pb_html_content',
			'title'       => 'HTML Content',
			'description' => 'Custom HTML content module (supports scripts)',
			'category'    => 'content',
		),
		array(
			'name'        => 'et_pb_code',
			'title'       => 'Code',
			'description' => 'Custom HTML/CSS/JS module',
			'category'    => 'content',
		),

		// Additional common modules.
		array(
			'name'        => 'et_pb_slider',
			'title'       => 'Slider',
			'description' => 'Content slider module',
			'category'    => 'media',
		),
		array(
			'name'        => 'et_pb_testimonial',
			'title'       => 'Testimonial',
			'description' => 'Testimonial module',
			'category'    => 'content',
		),
		array(
			'name'        => 'et_pb_team_member',
			'title'       => 'Team Member',
			'description' => 'Team member profile module',
			'category'    => 'content',
		),
		array(
			'name'        => 'et_pb_pricing_tables',
			'title'       => 'Pricing Tables',
			'description' => 'Pricing table module',
			'category'    => 'content',
		),
		array(
			'name'        => 'et_pb_contact_form',
			'title'       => 'Contact Form',
			'description' => 'Contact form module',
			'category'    => 'form',
		),
		array(
			'name'        => 'et_pb_gallery',
			'title'       => 'Gallery',
			'description' => 'Image gallery module',
			'category'    => 'media',
		),
		array(
			'name'        => 'et_pb_accordion',
			'title'       => 'Accordion',
			'description' => 'Accordion module',
			'category'    => 'content',
		),
		array(
			'name'        => 'et_pb_tabs',
			'title'       => 'Tabs',
			'description' => 'Tabs module',
			'category'    => 'content',
		),
		array(
			'name'        => 'et_pb_blog',
			'title'       => 'Blog',
			'description' => 'Blog posts module',
			'category'    => 'content',
		),
		array(
			'name'        => 'et_pb_portfolio',
			'title'       => 'Portfolio',
			'description' => 'Portfolio module',
			'category'    => 'content',
		),

		// Additional specialized modules.
		array(
			'name'        => 'et_pb_circle_counter',
			'title'       => 'Circle Counter',
			'description' => 'Animated circle counter module',
			'category'    => 'content',
		),
		array(
			'name'        => 'et_pb_counters',
			'title'       => 'Counters',
			'description' => 'Animated counters module',
			'category'    => 'content',
		),
		array(
			'name'        => 'et_pb_divider',
			'title'       => 'Divider',
			'description' => 'Divider line module',
			'category'    => 'content',
		),
		array(
			'name'        => 'et_pb_filterable_portfolio',
			'title'       => 'Filterable Portfolio',
			'description' => 'Filterable portfolio module',
			'category'    => 'content',
		),
		array(
			'name'        => 'et_pb_fullwidth_code',
			'title'       => 'Fullwidth Code',
			'description' => 'Fullwidth code module',
			'category'    => 'content',
		),
		array(
			'name'        => 'et_pb_fullwidth_header',
			'title'       => 'Fullwidth Header',
			'description' => 'Fullwidth header module',
			'category'    => 'content',
		),
		array(
			'name'        => 'et_pb_fullwidth_image',
			'title'       => 'Fullwidth Image',
			'description' => 'Fullwidth image module',
			'category'    => 'media',
		),
		array(
			'name'        => 'et_pb_fullwidth_map',
			'title'       => 'Fullwidth Map',
			'description' => 'Fullwidth map module',
			'category'    => 'content',
		),
		array(
			'name'        => 'et_pb_fullwidth_portfolio',
			'title'       => 'Fullwidth Portfolio',
			'description' => 'Fullwidth portfolio module',
			'category'    => 'content',
		),
		array(
			'name'        => 'et_pb_fullwidth_post_content',
			'title'       => 'Fullwidth Post Content',
			'description' => 'Fullwidth post content module',
			'category'    => 'content',
		),
		array(
			'name'        => 'et_pb_fullwidth_post_slider',
			'title'       => 'Fullwidth Post Slider',
			'description' => 'Fullwidth post slider module',
			'category'    => 'content',
		),
		array(
			'name'        => 'et_pb_fullwidth_post_title',
			'title'       => 'Fullwidth Post Title',
			'description' => 'Fullwidth post title module',
			'category'    => 'content',
		),
		array(
			'name'        => 'et_pb_fullwidth_slider',
			'title'       => 'Fullwidth Slider',
			'description' => 'Fullwidth slider module',
			'category'    => 'media',
		),
		array(
			'name'        => 'et_pb_icon',
			'title'       => 'Icon',
			'description' => 'Icon module',
			'category'    => 'content',
		),
		array(
			'name'        => 'et_pb_login',
			'title'       => 'Login',
			'description' => 'Login form module',
			'category'    => 'form',
		),
		array(
			'name'        => 'et_pb_map',
			'title'       => 'Map',
			'description' => 'Google Maps module',
			'category'    => 'content',
		),
		array(
			'name'        => 'et_pb_menu',
			'title'       => 'Menu',
			'description' => 'Menu module',
			'category'    => 'content',
		),
		array(
			'name'        => 'et_pb_number_counter',
			'title'       => 'Number Counter',
			'description' => 'Animated number counter module',
			'category'    => 'content',
		),
		array(
			'name'        => 'et_pb_post_content',
			'title'       => 'Post Content',
			'description' => 'Post content module',
			'category'    => 'content',
		),
		array(
			'name'        => 'et_pb_post_nav',
			'title'       => 'Post Navigation',
			'description' => 'Post navigation module',
			'category'    => 'content',
		),
		array(
			'name'        => 'et_pb_post_slider',
			'title'       => 'Post Slider',
			'description' => 'Post slider module',
			'category'    => 'content',
		),
		array(
			'name'        => 'et_pb_post_title',
			'title'       => 'Post Title',
			'description' => 'Post title module',
			'category'    => 'content',
		),
		array(
			'name'        => 'et_pb_search',
			'title'       => 'Search',
			'description' => 'Search form module',
			'category'    => 'form',
		),
		array(
			'name'        => 'et_pb_sidebar',
			'title'       => 'Sidebar',
			'description' => 'Sidebar module',
			'category'    => 'layout',
		),
		array(
			'name'        => 'et_pb_signup',
			'title'       => 'Signup',
			'description' => 'Email signup form module',
			'category'    => 'form',
		),
		array(
			'name'        => 'et_pb_social_media_follow',
			'title'       => 'Social Media Follow',
			'description' => 'Social media links module',
			'category'    => 'content',
		),
		array(
			'name'        => 'et_pb_toggle',
			'title'       => 'Toggle',
			'description' => 'Toggle/accordion module',
			'category'    => 'content',
		),
		array(
			'name'        => 'et_pb_video_slider',
			'title'       => 'Video Slider',
			'description' => 'Video slider module',
			'category'    => 'media',
		),
	);
}

/**
 * Get Divi module schemas.
 *
 * @since 1.0.0
 * @return array Array of module schemas keyed by module name.
 */
function respira_get_divi_module_schemas() {
	// This will be populated by the schema class.
	// For now, return empty array - schemas are built dynamically.
	return array();
}

