<?php
/**
 * Divi Intelligence Loader.
 *
 * Loads Divi Intelligence addon if available.
 * Divi Intelligence provides enhanced Divi support with full module detection,
 * schemas, validation, and AI intelligence.
 *
 * @package    Respira_For_WordPress
 * @subpackage Respira_For_WordPress/includes/divi-intelligence
 */

/**
 * Divi Intelligence loader class.
 *
 * @since 1.0.0
 */
class Respira_Divi_Intelligence_Loader {

	/**
	 * Check if Divi Intelligence is available.
	 *
	 * @since 1.0.0
	 * @return bool True if Divi Intelligence is available.
	 */
	public static function is_available() {
		$loader_file = RESPIRA_PLUGIN_DIR . 'includes/divi-intelligence/class-divi-intelligence-loader.php';
		return file_exists( $loader_file );
	}

	/**
	 * Load Divi Intelligence.
	 *
	 * @since 1.0.0
	 * @return void
	 */
	public static function load() {
		$intelligence_dir = RESPIRA_PLUGIN_DIR . 'includes/divi-intelligence/';

		// Load core Divi Intelligence classes.
		$classes = array(
			'class-divi-module-registry.php',
			'class-divi-module-schema.php',
			'class-divi-validator.php',
			'class-divi-global-modules.php',
		);

		foreach ( $classes as $class_file ) {
			$file_path = $intelligence_dir . $class_file;
			if ( file_exists( $file_path ) ) {
				require_once $file_path;
			}
		}

		// Load data files.
		$data_files = array(
			'divi-modules.php',
			'divi-patterns.php',
		);

		foreach ( $data_files as $data_file ) {
			$file_path = $intelligence_dir . $data_file;
			if ( file_exists( $file_path ) ) {
				require_once $file_path;
			}
		}

		// Enhance the Divi builder class with Intelligence features.
		self::enhance_divi_builder();
	}

	/**
	 * Enhance the Divi builder class with Intelligence features.
	 *
	 * Divi Intelligence classes are now loaded and will be used
	 * by the Divi builder class when available.
	 *
	 * @since 1.0.0
	 * @return void
	 */
	private static function enhance_divi_builder() {
		// Classes are loaded and will be automatically used by Respira_Builder_Divi
		// when it checks for class_exists() calls.
		// No additional action needed - the builder class already checks for these classes.
	}
}

