<?php
/**
 * Brizy Intelligence Loader.
 *
 * Loads Brizy Intelligence addon if available.
 *
 * @package    Respira_For_WordPress
 * @subpackage Respira_For_WordPress/includes/page-builders/brizy-intelligence
 * @since      1.4.0
 */

/**
 * Brizy Intelligence loader class.
 *
 * @since 1.4.0
 */
class Respira_Brizy_Intelligence_Loader {

	/**
	 * Check if Brizy Intelligence is available.
	 *
	 * @since 1.4.0
	 * @return bool True if Brizy Intelligence is available.
	 */
	public static function is_available() {
		$loader_file = RESPIRA_PLUGIN_DIR . 'includes/brizy-intelligence/class-brizy-intelligence-loader.php';
		return file_exists( $loader_file );
	}

	/**
	 * Load Brizy Intelligence.
	 *
	 * @since 1.4.0
	 * @return void
	 */
	public static function load() {
		$intelligence_dir = RESPIRA_PLUGIN_DIR . 'includes/brizy-intelligence/';

		// Load core Brizy Intelligence classes.
		$classes = array(
			'class-brizy-element-registry.php',
			'class-brizy-element-schema.php',
			'class-brizy-validator.php',
		);

		foreach ( $classes as $class_file ) {
			$file_path = $intelligence_dir . $class_file;
			if ( file_exists( $file_path ) ) {
				require_once $file_path;
			}
		}

		// Load data files.
		$data_files = array(
			'brizy-patterns.php',
		);

		foreach ( $data_files as $data_file ) {
			$file_path = $intelligence_dir . $data_file;
			if ( file_exists( $file_path ) ) {
				require_once $file_path;
			}
		}
	}
}
