<?php
/**
 * Settings view.
 *
 * @package    Respira_For_WordPress
 * @subpackage Respira_For_WordPress/admin/views
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
?>

<div class="wrap respira-admin-page">
	<?php require_once RESPIRA_PLUGIN_DIR . 'admin/views/partials/header.php'; ?>
	<div class="respira-page-body">

	<?php settings_errors( 'respira_messages' ); ?>

	<form method="post" action="">
		<?php wp_nonce_field( 'respira_update_settings' ); ?>

		<div class="respira-card">
			<h2><?php esc_html_e( 'General Settings', 'respira-for-wordpress' ); ?></h2>
			<table class="form-table">
				<tr>
					<th scope="row"><?php esc_html_e( 'Auto Duplicate', 'respira-for-wordpress' ); ?></th>
					<td>
						<label class="respira-toggle">
							<input type="checkbox" name="auto_duplicate" value="1" <?php checked( get_option( 'respira_auto_duplicate', 1 ), 1 ); ?>>
							<span class="respira-toggle-slider"></span>
							<span class="respira-toggle-label"><?php esc_html_e( 'Always create duplicates before editing', 'respira-for-wordpress' ); ?></span>
						</label>
						<p class="description"><?php esc_html_e( 'For safety, Respira will create a duplicate of the original page before making any changes.', 'respira-for-wordpress' ); ?></p>
					</td>
				</tr>
				<tr>
					<th scope="row"><?php esc_html_e( 'Security Checks', 'respira-for-wordpress' ); ?></th>
					<td>
						<label class="respira-toggle">
							<input type="checkbox" name="security_checks" value="1" <?php checked( get_option( 'respira_security_checks', 1 ), 1 ); ?>>
							<span class="respira-toggle-slider"></span>
							<span class="respira-toggle-label"><?php esc_html_e( 'Validate content for security issues', 'respira-for-wordpress' ); ?></span>
						</label>
						<p class="description"><?php esc_html_e( 'Automatically scan content for XSS, SQL injection, and other security risks.', 'respira-for-wordpress' ); ?></p>
					</td>
				</tr>
				<tr>
					<th scope="row"><?php esc_html_e( 'Audit Logging', 'respira-for-wordpress' ); ?></th>
					<td>
						<label class="respira-toggle">
							<input type="checkbox" name="audit_logging" value="1" <?php checked( get_option( 'respira_audit_logging', 1 ), 1 ); ?>>
							<span class="respira-toggle-slider"></span>
							<span class="respira-toggle-label"><?php esc_html_e( 'Log all API activity', 'respira-for-wordpress' ); ?></span>
						</label>
						<p class="description"><?php esc_html_e( 'Keep a record of all actions performed through the Respira API.', 'respira-for-wordpress' ); ?></p>
					</td>
				</tr>
				<tr>
					<th scope="row"><?php esc_html_e( 'Allow Direct Editing', 'respira-for-wordpress' ); ?></th>
					<td>
						<label class="respira-toggle">
							<input type="checkbox" name="allow_direct_edit" value="1" <?php checked( get_option( 'respira_allow_direct_edit', 0 ), 1 ); ?>>
							<span class="respira-toggle-slider"></span>
							<span class="respira-toggle-label"><?php esc_html_e( 'Allow AI to edit original pages directly', 'respira-for-wordpress' ); ?></span>
						</label>
						<p class="description"><?php esc_html_e( 'When enabled, AI can edit original pages using the force=true parameter. When disabled (recommended), AI can only edit Respira-created duplicates.', 'respira-for-wordpress' ); ?></p>
					</td>
				</tr>
				<tr>
					<th scope="row"><?php esc_html_e( 'Plugin Management (EXPERIMENTAL)', 'respira-for-wordpress' ); ?></th>
					<td>
						<label class="respira-toggle">
							<input type="checkbox" name="enable_plugin_management" value="1" <?php checked( get_option( 'respira_enable_plugin_management', 0 ), 1 ); ?>>
							<span class="respira-toggle-slider"></span>
							<span class="respira-toggle-label"><?php esc_html_e( 'Enable plugin management via API', 'respira-for-wordpress' ); ?></span>
						</label>
						<p class="description" style="color: #d63638;">
							<strong><?php esc_html_e( '⚠️ EXPERIMENTAL FEATURE:', 'respira-for-wordpress' ); ?></strong>
							<?php esc_html_e( 'Allows AI to install, activate, deactivate, update, and delete plugins. Use with extreme caution and only if you fully trust the AI assistant. All plugin management actions are logged.', 'respira-for-wordpress' ); ?>
						</p>
						<?php if ( get_option( 'respira_enable_plugin_management', 0 ) ) : ?>
						<p class="description" style="background: #fcf3cd; padding: 10px; border-left: 4px solid #dba617;">
							<strong><?php esc_html_e( 'Plugin Management is currently ENABLED.', 'respira-for-wordpress' ); ?></strong>
							<?php esc_html_e( 'The AI can now modify your WordPress plugins. Make sure you have recent backups.', 'respira-for-wordpress' ); ?>
						</p>
						<?php endif; ?>
					</td>
				</tr>
				<tr>
					<th scope="row">
						<label for="rate_limit"><?php esc_html_e( 'Rate Limit', 'respira-for-wordpress' ); ?></label>
					</th>
					<td>
						<input type="number" name="rate_limit" id="rate_limit" value="<?php echo esc_attr( get_option( 'respira_rate_limit', 100 ) ); ?>" min="1" max="1000" class="small-text">
						<?php esc_html_e( 'requests per hour', 'respira-for-wordpress' ); ?>
						<p class="description"><?php esc_html_e( 'Maximum number of API requests allowed per hour per API key.', 'respira-for-wordpress' ); ?></p>
					</td>
				</tr>
			</table>
		</div>

		<!-- Usage Statistics Privacy Notice -->
		<div class="respira-card" style="margin-top: 24px; border-left: 4px solid #0A9396;">
			<h2 style="color: #0dbdc1; margin-top: 0;"><?php esc_html_e( 'Usage Statistics & Privacy', 'respira-for-wordpress' ); ?></h2>
			<div style="background: rgba(10, 147, 150, 0.1); padding: 16px; border-radius: 8px; margin-top: 12px;">
				<p style="margin: 0 0 12px 0; color: #d1d5db; line-height: 1.6;">
					<strong style="color: #0dbdc1;"><?php esc_html_e( 'Your privacy is important to us.', 'respira-for-wordpress' ); ?></strong>
				</p>
				<p style="margin: 0 0 12px 0; color: #d1d5db; line-height: 1.6;">
					<?php esc_html_e( 'Respira tracks anonymous usage statistics to help improve the product. We collect:', 'respira-for-wordpress' ); ?>
				</p>
				<ul style="margin: 0 0 12px 0; padding-left: 24px; color: #d1d5db; line-height: 1.8;">
					<li><?php esc_html_e( 'Number of pages/posts updated (counts only)', 'respira-for-wordpress' ); ?></li>
					<li><?php esc_html_e( 'Approximate lines of code estimate (NOT actual code)', 'respira-for-wordpress' ); ?></li>
					<li><?php esc_html_e( 'Action types (e.g., "page updated")', 'respira-for-wordpress' ); ?></li>
				</ul>
				<p style="margin: 0 0 12px 0; color: #d1d5db; line-height: 1.6;">
					<strong style="color: #ffffff;"><?php esc_html_e( 'We do NOT collect or store:', 'respira-for-wordpress' ); ?></strong>
				</p>
				<ul style="margin: 0; padding-left: 24px; color: #d1d5db; line-height: 1.8;">
					<li><?php esc_html_e( 'Your actual page/post content or code', 'respira-for-wordpress' ); ?></li>
					<li><?php esc_html_e( 'Personal data or user information', 'respira-for-wordpress' ); ?></li>
					<li><?php esc_html_e( 'Database queries or configuration', 'respira-for-wordpress' ); ?></li>
					<li><?php esc_html_e( 'Any sensitive or confidential information', 'respira-for-wordpress' ); ?></li>
				</ul>
				<p style="margin: 12px 0 0 0; color: #9ca3af; font-size: 13px; line-height: 1.6;">
					<?php esc_html_e( 'All usage statistics are aggregated and anonymous. Your WordPress content remains entirely on your server and is never transmitted to or stored on our servers.', 'respira-for-wordpress' ); ?>
					<a href="https://respira.press/privacy" target="_blank" style="color: #0dbdc1; text-decoration: underline;">
						<?php esc_html_e( 'Learn more in our Privacy Policy', 'respira-for-wordpress' ); ?>
					</a>
				</p>
			</div>
		</div>

		<p class="submit">
			<input type="submit" name="respira_update_settings" class="button button-primary" value="<?php esc_attr_e( 'Save Settings', 'respira-for-wordpress' ); ?>">
		</p>
	</form>

	</div>

	<?php require_once RESPIRA_PLUGIN_DIR . 'admin/views/partials/footer.php'; ?>
</div>
