<?php
/**
 * Admin Header Partial
 *
 * Unified header component for all admin pages.
 *
 * @package    Respira_For_WordPress
 * @subpackage Respira_For_WordPress/admin/views/partials
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Check license status for header styling
$license_info = Respira_License::get_license_info();
$is_license_active = $license_info['is_pro'];
$header_class = $is_license_active ? 'respira-header-licensed' : 'respira-header-unlicensed';

// Check if update is available (with error handling)
$update_info = false;
if ( class_exists( 'Respira_Updater' ) ) {
	try {
		$update_info = Respira_Updater::check_update_available();
	} catch ( Exception $e ) {
		// Silently fail - don't break the page if update check fails
		$update_info = false;
	}
}
?>

<div class="respira-admin-header <?php echo esc_attr( $header_class ); ?>">
	<div class="respira-admin-header-inner">
		<div class="respira-admin-header-left">
			<div class="respira-admin-logo">
				<img src="<?php echo esc_url( RESPIRA_PLUGIN_URL . 'admin/assets/images/respira-logo.png' ); ?>" alt="<?php esc_attr_e( 'Respira Logo', 'respira-for-wordpress' ); ?>" />
			</div>
			<div class="respira-admin-branding">
				<h1 class="respira-admin-title">
					<?php esc_html_e( 'Respira for WordPress', 'respira-for-wordpress' ); ?>
					<span class="respira-admin-version-badge">v<?php echo esc_html( RESPIRA_VERSION ); ?></span>
				</h1>
				<?php if ( $update_info && $update_info['available'] ) : ?>
					<div class="respira-update-notification">
						<span class="respira-update-text">
							<?php
							printf(
								/* translators: %s: New version number */
								esc_html__( 'New %s version available:', 'respira-for-wordpress' ),
								esc_html( $update_info['version'] )
							);
							?>
						</span>
						<button type="button" class="respira-update-now-button" data-nonce="<?php echo esc_attr( wp_create_nonce( 'respira_admin_nonce' ) ); ?>">
							<?php esc_html_e( 'Update Now', 'respira-for-wordpress' ); ?>
						</button>
						<span class="respira-update-separator">|</span>
						<a href="https://respira.press/releases" target="_blank" rel="noopener noreferrer" class="respira-update-changelog-link">
							<?php esc_html_e( 'Changelog', 'respira-for-wordpress' ); ?>
						</a>
					</div>
				<?php endif; ?>
				<?php if ( ! $is_license_active ) : ?>
					<div class="respira-license-notice-inline">
						<span class="dashicons dashicons-warning"></span>
						<?php esc_html_e( 'License Required', 'respira-for-wordpress' ); ?>
						<a href="<?php echo esc_url( admin_url( 'admin.php?page=respira-license' ) ); ?>" class="respira-license-notice-link">
							<?php esc_html_e( 'Activate your license', 'respira-for-wordpress' ); ?>
						</a>
					</div>
				<?php endif; ?>
			</div>
		</div>
		<div class="respira-admin-header-right">
			<a href="https://respira.press/dashboard" target="_blank" class="respira-admin-account-link">
				<span class="dashicons dashicons-admin-users"></span>
				<?php esc_html_e( 'Manage Account', 'respira-for-wordpress' ); ?>
			</a>
		</div>
	</div>
</div>

