<?php
/**
 * Admin Footer Partial
 *
 * Unified footer component for all admin pages.
 *
 * @package    Respira_For_WordPress
 * @subpackage Respira_For_WordPress/admin/views/partials
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
?>

<div class="respira-admin-footer">
	<div class="respira-admin-footer-inner">
		<div class="respira-admin-footer-links">
			<a href="https://respira.press/documentation" target="_blank" class="respira-admin-footer-link">
				<span class="dashicons dashicons-book"></span>
				<?php esc_html_e( 'Documentation', 'respira-for-wordpress' ); ?>
			</a>
			<span class="respira-admin-footer-separator">•</span>
			<a href="https://respira.press/dashboard" target="_blank" class="respira-admin-footer-link">
				<span class="dashicons dashicons-plus-alt"></span>
				<?php esc_html_e( 'Add More Sites', 'respira-for-wordpress' ); ?>
			</a>
			<span class="respira-admin-footer-separator">•</span>
			<a href="https://respira.press/dashboard" target="_blank" class="respira-admin-footer-link">
				<span class="dashicons dashicons-groups"></span>
				<?php esc_html_e( 'Become an Affiliate', 'respira-for-wordpress' ); ?>
			</a>
		</div>
		<div class="respira-admin-footer-credit">
			<?php
			/* translators: %s: Respira version number */
			printf( esc_html__( 'Respira for WordPress v%s', 'respira-for-wordpress' ), esc_html( RESPIRA_VERSION ) );
			?>
		</div>
	</div>
</div>

