<?php
/**
 * License activation view.
 *
 * @package    Respira_For_WordPress
 * @subpackage Respira_For_WordPress/admin/views
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$license_info = Respira_License::get_license_info();
$license_key = $license_info['key'];
$license_status = $license_info['status'];
$is_active = $license_info['is_pro'];
?>

<div class="wrap respira-admin-page">
	<?php require_once RESPIRA_PLUGIN_DIR . 'admin/views/partials/header.php'; ?>
	<div class="respira-page-body">
		<?php settings_errors( 'respira_messages' ); ?>

		<div class="respira-card">
			<h2><?php esc_html_e( 'Activate License', 'respira-for-wordpress' ); ?></h2>
			<p class="description">
				<?php esc_html_e( 'Enter your Respira license key to activate the plugin. You can find your license key in your account dashboard at respira.press.', 'respira-for-wordpress' ); ?>
			</p>

			<?php if ( empty( $license_key ) || 'inactive' === $license_status ) : ?>
				<form method="post" action="" id="respira-activate-license-form">
					<?php wp_nonce_field( 'respira_activate_license' ); ?>
					<table class="form-table">
						<tr>
							<th scope="row">
								<label for="license_key"><?php esc_html_e( 'License Key', 'respira-for-wordpress' ); ?></label>
							</th>
							<td>
								<input type="text" name="license_key" id="license_key" class="regular-text" placeholder="respira_xxxxxxxxxxxx" value="<?php echo esc_attr( $license_key ); ?>" required>
								<p class="description">
									<?php esc_html_e( 'Enter your license key (starts with "respira_").', 'respira-for-wordpress' ); ?>
									<br>
									<a href="https://respira.press/dashboard" target="_blank"><?php esc_html_e( 'Get your license key from your dashboard →', 'respira-for-wordpress' ); ?></a>
								</p>
							</td>
						</tr>
					</table>

					<!-- Privacy Policy and Terms Agreement -->
					<div class="respira-agreement-section" style="background: rgba(10, 147, 150, 0.1); border-left: 4px solid #0A9396; padding: 20px; margin: 20px 0; border-radius: 8px;">
						<h3 style="color: #0dbdc1; margin-top: 0; margin-bottom: 16px; font-size: 16px;">
							<?php esc_html_e( 'Agreement Required', 'respira-for-wordpress' ); ?>
						</h3>
						<p style="color: #d1d5db; margin-bottom: 16px; line-height: 1.6; font-size: 14px;">
							<?php esc_html_e( 'Please read and confirm that you agree to our Privacy Policy and Terms of Service before activating your license.', 'respira-for-wordpress' ); ?>
						</p>
						
						<div style="display: flex; flex-direction: column; gap: 12px;">
							<label style="display: flex; align-items: flex-start; gap: 10px; cursor: pointer; color: #d1d5db; line-height: 1.6;">
								<input 
									type="checkbox" 
									name="agree_privacy" 
									id="agree_privacy" 
									value="1" 
									required
									style="margin-top: 4px; flex-shrink: 0; cursor: pointer;"
								>
								<span>
									<?php
									printf(
										/* translators: %1$s: Privacy Policy link */
										esc_html__( 'I have read and agree to the %1$s.', 'respira-for-wordpress' ),
										'<a href="https://respira.press/privacy" target="_blank" rel="noopener noreferrer" style="color: #0dbdc1; text-decoration: underline;">' . esc_html__( 'Privacy Policy', 'respira-for-wordpress' ) . '</a>'
									);
									?>
									<span style="color: #ef4444;">*</span>
								</span>
							</label>
							
							<label style="display: flex; align-items: flex-start; gap: 10px; cursor: pointer; color: #d1d5db; line-height: 1.6;">
								<input 
									type="checkbox" 
									name="agree_terms" 
									id="agree_terms" 
									value="1" 
									required
									style="margin-top: 4px; flex-shrink: 0; cursor: pointer;"
								>
								<span>
									<?php
									printf(
										/* translators: %1$s: Terms of Service link */
										esc_html__( 'I have read and agree to the %1$s.', 'respira-for-wordpress' ),
										'<a href="https://respira.press/terms" target="_blank" rel="noopener noreferrer" style="color: #0dbdc1; text-decoration: underline;">' . esc_html__( 'Terms of Service', 'respira-for-wordpress' ) . '</a>'
									);
									?>
									<span style="color: #ef4444;">*</span>
								</span>
							</label>
						</div>

						<div style="background: rgba(10, 147, 150, 0.15); padding: 12px; border-radius: 6px; margin-top: 16px;">
							<p style="margin: 0; color: #9ca3af; font-size: 13px; line-height: 1.6;">
								<strong style="color: #0dbdc1;"><?php esc_html_e( 'Privacy Note:', 'respira-for-wordpress' ); ?></strong>
								<?php esc_html_e( 'By using Respira, you acknowledge that we collect anonymous usage statistics (page counts, line estimates) to improve the product. Your actual WordPress content, code, and data are NEVER transmitted or stored on our servers.', 'respira-for-wordpress' ); ?>
							</p>
						</div>
					</div>

					<p class="submit">
						<input type="submit" name="respira_activate_license" id="respira-activate-submit" class="button button-primary" value="<?php esc_attr_e( 'Activate License', 'respira-for-wordpress' ); ?>">
					</p>
				</form>

				<script>
				(function() {
					const form = document.getElementById('respira-activate-license-form');
					const submitBtn = document.getElementById('respira-activate-submit');
					const privacyCheckbox = document.getElementById('agree_privacy');
					const termsCheckbox = document.getElementById('agree_terms');

					if (form && submitBtn && privacyCheckbox && termsCheckbox) {
						form.addEventListener('submit', function(e) {
							if (!privacyCheckbox.checked || !termsCheckbox.checked) {
								e.preventDefault();
								alert('<?php echo esc_js( __( 'Please confirm that you have read and agree to both the Privacy Policy and Terms of Service before activating your license.', 'respira-for-wordpress' ) ); ?>');
								return false;
							}
						});

						// Disable submit button until both checkboxes are checked
						function updateSubmitButton() {
							if (privacyCheckbox.checked && termsCheckbox.checked) {
								submitBtn.disabled = false;
								submitBtn.style.opacity = '1';
								submitBtn.style.cursor = 'pointer';
							} else {
								submitBtn.disabled = true;
								submitBtn.style.opacity = '0.6';
								submitBtn.style.cursor = 'not-allowed';
							}
						}

						privacyCheckbox.addEventListener('change', updateSubmitButton);
						termsCheckbox.addEventListener('change', updateSubmitButton);
						updateSubmitButton(); // Initial state
					}
				})();
				</script>
			<?php else : ?>
				<div class="respira-license-status">
					<table class="form-table">
						<tr>
							<th scope="row"><?php esc_html_e( 'License Status', 'respira-for-wordpress' ); ?></th>
							<td>
								<?php if ( 'active' === $license_status || 'trial' === $license_status ) : ?>
									<span class="respira-status-active"><?php esc_html_e( 'Active', 'respira-for-wordpress' ); ?></span>
								<?php else : ?>
									<span class="respira-status-inactive"><?php esc_html_e( 'Inactive', 'respira-for-wordpress' ); ?></span>
								<?php endif; ?>
							</td>
						</tr>
						<tr>
							<th scope="row"><?php esc_html_e( 'License Key', 'respira-for-wordpress' ); ?></th>
							<td>
								<code><?php echo esc_html( $license_key ); ?></code>
							</td>
						</tr>
						<?php if ( isset( $license_info['data']['max_sites'] ) ) : ?>
							<tr>
								<th scope="row"><?php esc_html_e( 'Max Sites', 'respira-for-wordpress' ); ?></th>
								<td><?php echo esc_html( $license_info['data']['max_sites'] ); ?></td>
							</tr>
						<?php endif; ?>
					</table>
					<form method="post" action="" style="margin-top: 20px;">
						<?php wp_nonce_field( 'respira_deactivate_license' ); ?>
						<p class="submit">
							<input type="submit" name="respira_deactivate_license" class="button button-secondary" value="<?php esc_attr_e( 'Deactivate License', 'respira-for-wordpress' ); ?>" onclick="return confirm('<?php esc_attr_e( 'Are you sure you want to deactivate this license?', 'respira-for-wordpress' ); ?>');">
						</p>
					</form>
				</div>
			<?php endif; ?>
		</div>

		<?php if ( empty( $license_key ) || 'inactive' === $license_status ) : ?>
			<div class="respira-card" style="margin-top: 20px;">
				<h3><?php esc_html_e( 'Don\'t have a license?', 'respira-for-wordpress' ); ?></h3>
				<p>
					<?php esc_html_e( 'Start with a free 7-day trial or purchase a license to unlock all features.', 'respira-for-wordpress' ); ?>
				</p>
				<p>
					<a href="https://respira.press/dashboard" target="_blank" class="button button-primary">
						<?php esc_html_e( 'Get License Key →', 'respira-for-wordpress' ); ?>
					</a>
				</p>
			</div>
		<?php endif; ?>
	</div>

	<?php require_once RESPIRA_PLUGIN_DIR . 'admin/views/partials/footer.php'; ?>
</div>
