<?php
/**
 * Audit Log view.
 *
 * @package    Respira_For_WordPress
 * @subpackage Respira_For_WordPress/admin/views
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

global $wpdb;
$table_name = $wpdb->prefix . 'respira_audit_log';

// Pagination.
$per_page = 20;
$page = isset( $_GET['paged'] ) ? absint( $_GET['paged'] ) : 1;
$offset = ( $page - 1 ) * $per_page;

$total_logs = $wpdb->get_var( "SELECT COUNT(*) FROM $table_name" );
$total_pages = ceil( $total_logs / $per_page );

$logs = $wpdb->get_results(
	$wpdb->prepare(
		"SELECT * FROM $table_name ORDER BY created_at DESC LIMIT %d OFFSET %d",
		$per_page,
		$offset
	)
);
?>

<div class="wrap respira-admin-page">
	<?php require_once RESPIRA_PLUGIN_DIR . 'admin/views/partials/header.php'; ?>
	<div class="respira-page-body">

	<div class="respira-card">
		<?php if ( $logs ) : ?>
			<div class="respira-table-wrapper">
				<table class="wp-list-table widefat fixed striped respira-table">
					<thead>
						<tr>
							<th><?php esc_html_e( 'Time', 'respira-for-wordpress' ); ?></th>
							<th><?php esc_html_e( 'Action', 'respira-for-wordpress' ); ?></th>
							<th><?php esc_html_e( 'Resource', 'respira-for-wordpress' ); ?></th>
							<th><?php esc_html_e( 'IP Address', 'respira-for-wordpress' ); ?></th>
							<th><?php esc_html_e( 'Status', 'respira-for-wordpress' ); ?></th>
						</tr>
					</thead>
					<tbody>
						<?php foreach ( $logs as $log ) : ?>
							<tr>
								<td><?php echo esc_html( mysql2date( 'Y-m-d H:i:s', $log->created_at ) ); ?></td>
								<td><strong><?php echo esc_html( $log->action ); ?></strong></td>
								<td>
									<?php
									if ( $log->resource_type && $log->resource_id ) {
										echo esc_html( $log->resource_type . ' #' . $log->resource_id );
									} else {
										echo '—';
									}
									?>
								</td>
								<td><?php echo esc_html( $log->ip_address ); ?></td>
								<td>
									<?php
									$status_class = $log->response_code >= 200 && $log->response_code < 300 ? 'success' : 'error';
									?>
									<span class="respira-status-<?php echo esc_attr( $status_class ); ?>">
										<?php echo esc_html( $log->response_code ); ?>
									</span>
								</td>
							</tr>
						<?php endforeach; ?>
					</tbody>
				</table>
			</div>

			<?php if ( $total_pages > 1 ) : ?>
				<div class="tablenav">
					<div class="tablenav-pages">
						<?php
						echo paginate_links(
							array(
								'base'    => add_query_arg( 'paged', '%#%' ),
								'format'  => '',
								'current' => $page,
								'total'   => $total_pages,
							)
						);
						?>
					</div>
				</div>
			<?php endif; ?>
		<?php else : ?>
			<p><?php esc_html_e( 'No activity logged yet.', 'respira-for-wordpress' ); ?></p>
		<?php endif; ?>
	</div>

	</div>

	<?php require_once RESPIRA_PLUGIN_DIR . 'admin/views/partials/footer.php'; ?>
</div>
