/**
 * Respira for WordPress - Admin JavaScript
 */

(function($) {
    'use strict';

    $(document).ready(function() {
        // Copy to clipboard functionality
        $('.respira-copy-btn').on('click', function(e) {
            e.preventDefault();
            var $btn = $(this);
            var textToCopy = $btn.data('copy');

            // Create temporary input
            var $temp = $('<input>');
            $('body').append($temp);
            $temp.val(textToCopy).select();
            document.execCommand('copy');
            $temp.remove();

            // Visual feedback
            var originalText = $btn.text();
            $btn.text('Copied!').addClass('copied');

            setTimeout(function() {
                $btn.text(originalText).removeClass('copied');
            }, 2000);
        });

        // AI Tool Tab Switching
        $('.respira-tab-btn').on('click', function(e) {
            e.preventDefault();
            var tool = $(this).data('tool');

            // Remove active class from all tabs and content
            $('.respira-tab-btn').removeClass('active');
            $('.respira-tool-content').removeClass('active');

            // Add active class to clicked tab and corresponding content
            $(this).addClass('active');
            $('.respira-tool-content[data-tool="' + tool + '"]').addClass('active');
        });

        // Collapsible Section Toggle
        $('.respira-section-collapsible .respira-section-header').on('click', function() {
            var $section = $(this).closest('.respira-section-collapsible');
            $section.toggleClass('collapsed');
            
            // Save state to localStorage
            var sectionId = $section.attr('id') || $section.find('h2').text().trim();
            if ($section.hasClass('collapsed')) {
                localStorage.setItem('respira_collapsed_' + sectionId, 'true');
            } else {
                localStorage.removeItem('respira_collapsed_' + sectionId);
            }
        });

        // Restore collapsed state from localStorage
        $('.respira-section-collapsible').each(function() {
            var $section = $(this);
            var sectionId = $section.attr('id') || $section.find('h2').text().trim();
            if (localStorage.getItem('respira_collapsed_' + sectionId) === 'true') {
                $section.addClass('collapsed');
            }
        });

        // Plugin Update Handler
        $('.respira-update-now-button').on('click', function(e) {
            e.preventDefault();
            var $btn = $(this);
            var $notification = $btn.closest('.respira-update-notification');
            var originalText = $btn.text();
            var nonce = $btn.data('nonce');

            // Disable button and show loading state
            $btn.prop('disabled', true).text('Updating...').addClass('updating');
            $notification.addClass('updating');

            // Make AJAX request
            $.ajax({
                url: respira_admin.ajax_url,
                type: 'POST',
                data: {
                    action: 'respira_update_plugin',
                    nonce: nonce
                },
                success: function(response) {
                    if (response.success) {
                        // Show success message
                        $notification.removeClass('updating').addClass('success');
                        $btn.text('Updated!');
                        
                        // Reload page after short delay
                        setTimeout(function() {
                            window.location.reload();
                        }, 1500);
                    } else {
                        // Show error message
                        $notification.removeClass('updating').addClass('error');
                        $btn.prop('disabled', false).text(originalText).removeClass('updating');
                        
                        var errorMsg = response.data && response.data.message ? response.data.message : 'Update failed. Please try again.';
                        alert(errorMsg);
                    }
                },
                error: function(xhr, status, error) {
                    // Show error message
                    $notification.removeClass('updating').addClass('error');
                    $btn.prop('disabled', false).text(originalText).removeClass('updating');
                    alert('Update failed: ' + error + '. Please try updating manually from WordPress Updates page.');
                }
            });
        });
    });

})(jQuery);
