<?php
/**
 * WPBakery layout patterns library.
 *
 * Common layout patterns for WPBakery shortcodes.
 *
 * @package    Respira_For_WordPress
 * @subpackage Respira_For_WordPress/includes/page-builders/wpbakery-intelligence
 * @since      1.3.0
 */

/**
 * Get WPBakery layout patterns.
 *
 * @since  1.3.0
 * @return array Array of patterns.
 */
function respira_get_wpbakery_patterns() {
	return array(
		'hero-section' => array(
			'title'       => __( 'Hero Section', 'respira-for-wordpress' ),
			'description' => __( 'Full-width hero section with heading and CTA', 'respira-for-wordpress' ),
			'category'    => 'headers',
			'structure'   => array(
				array(
					'type'       => 'vc_row',
					'attributes' => array(
						'full_width' => 'stretch_row_content_no_spaces',
					),
					'children'   => array(
						array(
							'type'       => 'vc_column',
							'attributes' => array(),
							'children'   => array(
								array(
									'type'       => 'vc_column_text',
									'attributes' => array(),
									'content'    => '<h1>' . __( 'Welcome to Our Site', 'respira-for-wordpress' ) . '</h1><p>' . __( 'Your compelling tagline here', 'respira-for-wordpress' ) . '</p>',
								),
							),
						),
					),
				),
			),
		),
		'three-column-features' => array(
			'title'       => __( 'Three Column Features', 'respira-for-wordpress' ),
			'description' => __( 'Three-column layout with feature items', 'respira-for-wordpress' ),
			'category'    => 'content',
			'structure'   => array(
				array(
					'type'       => 'vc_row',
					'attributes' => array(),
					'children'   => array(
						array(
							'type'       => 'vc_column',
							'attributes' => array(),
							'children'   => array(
								array(
									'type'       => 'vc_column_text',
									'attributes' => array(),
									'content'    => '<h3>' . __( 'Feature 1', 'respira-for-wordpress' ) . '</h3><p>' . __( 'Feature description', 'respira-for-wordpress' ) . '</p>',
								),
							),
						),
						array(
							'type'       => 'vc_column',
							'attributes' => array(),
							'children'   => array(
								array(
									'type'       => 'vc_column_text',
									'attributes' => array(),
									'content'    => '<h3>' . __( 'Feature 2', 'respira-for-wordpress' ) . '</h3><p>' . __( 'Feature description', 'respira-for-wordpress' ) . '</p>',
								),
							),
						),
						array(
							'type'       => 'vc_column',
							'attributes' => array(),
							'children'   => array(
								array(
									'type'       => 'vc_column_text',
									'attributes' => array(),
									'content'    => '<h3>' . __( 'Feature 3', 'respira-for-wordpress' ) . '</h3><p>' . __( 'Feature description', 'respira-for-wordpress' ) . '</p>',
								),
							),
						),
					),
				),
			),
		),
	);
}

