<?php
/**
 * Oxygen Builder Intelligence Loader.
 *
 * Loads Oxygen Builder Intelligence addon if available.
 *
 * @package    Respira_For_WordPress
 * @subpackage Respira_For_WordPress/includes/page-builders/oxygen-intelligence
 * @since      1.4.0
 */

/**
 * Oxygen Builder Intelligence loader class.
 *
 * @since 1.4.0
 */
class Respira_Oxygen_Intelligence_Loader {

	/**
	 * Check if Oxygen Builder Intelligence is available.
	 *
	 * @since 1.4.0
	 * @return bool True if Oxygen Builder Intelligence is available.
	 */
	public static function is_available() {
		$loader_file = RESPIRA_PLUGIN_DIR . 'includes/oxygen-intelligence/class-oxygen-intelligence-loader.php';
		return file_exists( $loader_file );
	}

	/**
	 * Load Oxygen Builder Intelligence.
	 *
	 * @since 1.4.0
	 * @return void
	 */
	public static function load() {
		$intelligence_dir = RESPIRA_PLUGIN_DIR . 'includes/oxygen-intelligence/';

		// Load core Oxygen Builder Intelligence classes.
		$classes = array(
			'class-oxygen-component-registry.php',
			'class-oxygen-component-schema.php',
			'class-oxygen-validator.php',
		);

		foreach ( $classes as $class_file ) {
			$file_path = $intelligence_dir . $class_file;
			if ( file_exists( $file_path ) ) {
				require_once $file_path;
			}
		}

		// Load data files.
		$data_files = array(
			'oxygen-patterns.php',
		);

		foreach ( $data_files as $data_file ) {
			$file_path = $intelligence_dir . $data_file;
			if ( file_exists( $file_path ) ) {
				require_once $file_path;
			}
		}
	}
}
