<?php
/**
 * Divi Intelligence - Layout Patterns Library.
 *
 * Common Divi layout patterns and templates for AI assistants.
 * Part of Divi Intelligence addon for Respira for WordPress.
 *
 * @package    Respira_For_WordPress
 * @subpackage Respira_For_WordPress/includes/divi-intelligence
 */

/**
 * Get Divi layout patterns.
 *
 * @since 1.0.0
 * @return array Array of layout patterns.
 */
function respira_get_divi_patterns() {
	return array(
		'hero_section' => array(
			'name'        => 'Hero Section',
			'description' => 'Full-width hero section with background image, heading, and CTA button',
			'structure'  => array(
				array(
					'type'       => 'et_pb_section',
					'attributes' => array(
						'background_image' => '{background_image_url}',
						'background_color' => '{background_color}',
						'fullwidth'        => 'on',
					),
					'children'   => array(
						array(
							'type'       => 'et_pb_row',
							'attributes' => array(),
							'children'   => array(
								array(
									'type'       => 'et_pb_text',
									'attributes' => array(
										'text_orientation' => 'center',
									),
									'content'    => '<h1>{heading}</h1><p>{subheading}</p>',
								),
								array(
									'type'       => 'et_pb_button',
									'attributes' => array(
										'button_text'      => '{button_text}',
										'button_url'       => '{button_url}',
										'button_alignment' => 'center',
									),
								),
							),
						),
					),
				),
			),
		),
		'feature_grid' => array(
			'name'        => 'Feature Grid',
			'description' => 'Three-column feature grid with icons and descriptions',
			'structure'  => array(
				array(
					'type'       => 'et_pb_section',
					'attributes' => array(),
					'children'   => array(
						array(
							'type'       => 'et_pb_row',
							'attributes' => array(
								'column_structure' => '4_4_4',
							),
							'children'   => array(
								array(
									'type'       => 'et_pb_blurb',
									'attributes' => array(
										'title' => '{feature_1_title}',
										'image' => '{feature_1_icon}',
									),
									'content'    => '{feature_1_description}',
								),
								array(
									'type'       => 'et_pb_blurb',
									'attributes' => array(
										'title' => '{feature_2_title}',
										'image' => '{feature_2_icon}',
									),
									'content'    => '{feature_2_description}',
								),
								array(
									'type'       => 'et_pb_blurb',
									'attributes' => array(
										'title' => '{feature_3_title}',
										'image' => '{feature_3_icon}',
									),
									'content'    => '{feature_3_description}',
								),
							),
						),
					),
				),
			),
		),
		'testimonial_section' => array(
			'name'        => 'Testimonial Section',
			'description' => 'Testimonial section with multiple testimonials',
			'structure'  => array(
				array(
					'type'       => 'et_pb_section',
					'attributes' => array(
						'background_color' => '{section_bg_color}',
					),
					'children'   => array(
						array(
							'type'       => 'et_pb_row',
							'attributes' => array(),
							'children'   => array(
								array(
									'type'       => 'et_pb_text',
									'attributes' => array(
										'text_orientation' => 'center',
									),
									'content'    => '<h2>{section_heading}</h2>',
								),
								array(
									'type'       => 'et_pb_testimonial',
									'attributes' => array(
										'author' => '{testimonial_1_author}',
										'url'    => '{testimonial_1_url}',
									),
									'content'    => '{testimonial_1_text}',
								),
								array(
									'type'       => 'et_pb_testimonial',
									'attributes' => array(
										'author' => '{testimonial_2_author}',
										'url'    => '{testimonial_2_url}',
									),
									'content'    => '{testimonial_2_text}',
								),
							),
						),
					),
				),
			),
		),
		'pricing_table' => array(
			'name'        => 'Pricing Table',
			'description' => 'Three-column pricing table',
			'structure'  => array(
				array(
					'type'       => 'et_pb_section',
					'attributes' => array(),
					'children'   => array(
						array(
							'type'       => 'et_pb_row',
							'attributes' => array(
								'column_structure' => '4_4_4',
							),
							'children'   => array(
								array(
									'type'       => 'et_pb_pricing_tables',
									'attributes' => array(
										'title'        => '{plan_1_name}',
										'currency'     => '{currency}',
										'per'          => '{period}',
										'sum'          => '{plan_1_price}',
									),
									'content'    => '{plan_1_features}',
								),
								array(
									'type'       => 'et_pb_pricing_tables',
									'attributes' => array(
										'title'        => '{plan_2_name}',
										'currency'     => '{currency}',
										'per'          => '{period}',
										'sum'          => '{plan_2_price}',
									),
									'content'    => '{plan_2_features}',
								),
								array(
									'type'       => 'et_pb_pricing_tables',
									'attributes' => array(
										'title'        => '{plan_3_name}',
										'currency'     => '{currency}',
										'per'          => '{period}',
										'sum'          => '{plan_3_price}',
									),
									'content'    => '{plan_3_features}',
								),
							),
						),
					),
				),
			),
		),
		'cta_section' => array(
			'name'        => 'Call to Action Section',
			'description' => 'CTA section with heading, text, and button',
			'structure'  => array(
				array(
					'type'       => 'et_pb_section',
					'attributes' => array(
						'background_color' => '{section_bg_color}',
					),
					'children'   => array(
						array(
							'type'       => 'et_pb_row',
							'attributes' => array(),
							'children'   => array(
								array(
									'type'       => 'et_pb_cta',
									'attributes' => array(
										'title'      => '{cta_heading}',
										'button_text' => '{button_text}',
										'button_url'  => '{button_url}',
									),
									'content'    => '{cta_text}',
								),
							),
						),
					),
				),
			),
		),
		'blog_layout' => array(
			'name'        => 'Blog Layout',
			'description' => 'Blog posts display with sidebar',
			'structure'  => array(
				array(
					'type'       => 'et_pb_section',
					'attributes' => array(),
					'children'   => array(
						array(
							'type'       => 'et_pb_row',
							'attributes' => array(
								'column_structure' => '8_4',
							),
							'children'   => array(
								array(
									'type'       => 'et_pb_blog',
									'attributes' => array(
										'posts_number' => '{posts_per_page}',
									),
								),
								array(
									'type'       => 'et_pb_sidebar',
									'attributes' => array(
										'orientation' => 'right',
									),
								),
							),
						),
					),
				),
			),
		),
	);
}

