<?php
/**
 * Fired during plugin activation.
 *
 * @package    Respira_For_WordPress
 * @subpackage Respira_For_WordPress/includes
 */

/**
 * Fired during plugin activation.
 *
 * This class defines all code necessary to run during the plugin's activation.
 *
 * @since 1.0.0
 */
class Respira_Activator {

	/**
	 * Activate the plugin.
	 *
	 * Creates necessary database tables and sets default options.
	 *
	 * @since 1.0.0
	 */
	public static function activate() {
		global $wpdb;

		$charset_collate = $wpdb->get_charset_collate();

		// Create API keys table.
		$table_name = $wpdb->prefix . 'respira_api_keys';

		$sql = "CREATE TABLE IF NOT EXISTS $table_name (
			id bigint(20) NOT NULL AUTO_INCREMENT,
			api_key varchar(255) NOT NULL,
			user_id bigint(20) NOT NULL,
			name varchar(255) DEFAULT NULL,
			permissions text DEFAULT NULL,
			license_key varchar(255) DEFAULT NULL,
			last_used datetime DEFAULT NULL,
			created_at datetime NOT NULL,
			expires_at datetime DEFAULT NULL,
			is_active tinyint(1) DEFAULT 1,
			PRIMARY KEY  (id),
			UNIQUE KEY api_key (api_key),
			KEY user_id (user_id),
			KEY license_key (license_key)
		) $charset_collate;";

		require_once ABSPATH . 'wp-admin/includes/upgrade.php';
		dbDelta( $sql );

		// Create audit log table.
		$table_name = $wpdb->prefix . 'respira_audit_log';

		$sql = "CREATE TABLE IF NOT EXISTS $table_name (
			id bigint(20) NOT NULL AUTO_INCREMENT,
			api_key_id bigint(20) DEFAULT NULL,
			user_id bigint(20) DEFAULT NULL,
			action varchar(100) NOT NULL,
			resource_type varchar(50) DEFAULT NULL,
			resource_id bigint(20) DEFAULT NULL,
			ip_address varchar(45) DEFAULT NULL,
			user_agent text DEFAULT NULL,
			request_data longtext DEFAULT NULL,
			response_code int(11) DEFAULT NULL,
			created_at datetime NOT NULL,
			PRIMARY KEY  (id),
			KEY api_key_id (api_key_id),
			KEY user_id (user_id),
			KEY created_at (created_at)
		) $charset_collate;";

		dbDelta( $sql );

		// Set default options.
		add_option( 'respira_version', RESPIRA_VERSION );
		add_option( 'respira_auto_duplicate', 1 );
		add_option( 'respira_security_checks', 1 );
		add_option( 'respira_audit_logging', 1 );
		add_option( 'respira_rate_limit', 100 ); // Per hour.
		add_option( 'respira_allow_direct_edit', 0 ); // Disabled by default for safety.

		// Flush rewrite rules for REST API.
		flush_rewrite_rules();
	}
}
