<?php
/**
 * Brizy layout patterns library.
 *
 * Common layout patterns for Brizy elements.
 *
 * @package    Respira_For_WordPress
 * @subpackage Respira_For_WordPress/includes/page-builders/brizy-intelligence
 * @since      1.4.0
 */

/**
 * Get Brizy layout patterns.
 *
 * @since  1.4.0
 * @return array Array of patterns.
 */
function respira_get_brizy_patterns() {
	return array(
		'hero-section'           => array(
			'title'       => __( 'Hero Section', 'respira-for-wordpress' ),
			'description' => __( 'Full-width hero section with heading and CTA button', 'respira-for-wordpress' ),
			'category'    => 'headers',
			'structure'   => array(
				array(
					'type'  => 'Section',
					'value' => array(
						'bgColorHex' => '#0066CC',
						'paddingTop' => 80,
						'paddingBottom' => 80,
					),
					'items' => array(
						array(
							'type'  => 'Row',
							'value' => array(),
							'columns' => array(
								array(
									'type'  => 'Column',
									'value' => array(
										'width' => 100,
									),
									'items' => array(
										array(
											'type'  => 'RichText',
											'value' => array(
												'text' => '<h1 style="color: #FFFFFF; text-align: center;">' . __( 'Welcome to Our Amazing Service', 'respira-for-wordpress' ) . '</h1>',
											),
										),
										array(
											'type'  => 'Spacer',
											'value' => array(
												'height' => 20,
											),
										),
										array(
											'type'  => 'RichText',
											'value' => array(
												'text' => '<p style="color: #FFFFFF; text-align: center; font-size: 18px;">' . __( 'Your compelling tagline goes here', 'respira-for-wordpress' ) . '</p>',
											),
										),
										array(
											'type'  => 'Spacer',
											'value' => array(
												'height' => 30,
											),
										),
										array(
											'type'  => 'Button',
											'value' => array(
												'text'       => __( 'Get Started', 'respira-for-wordpress' ),
												'link'       => '#',
												'bgColorHex' => '#FFFFFF',
												'colorHex'   => '#0066CC',
											),
										),
									),
								),
							),
						),
					),
				),
			),
		),
		'three-column-features'  => array(
			'title'       => __( 'Three Column Features', 'respira-for-wordpress' ),
			'description' => __( 'Three-column layout with icon and text features', 'respira-for-wordpress' ),
			'category'    => 'content',
			'structure'   => array(
				array(
					'type'  => 'Section',
					'value' => array(
						'bgColorHex' => '#FFFFFF',
						'paddingTop' => 60,
						'paddingBottom' => 60,
					),
					'items' => array(
						array(
							'type'  => 'Row',
							'value' => array(),
							'columns' => array(
								array(
									'type'  => 'Column',
									'value' => array(
										'width' => 33.33,
									),
									'items' => array(
										array(
											'type'  => 'Icon',
											'value' => array(
												'name'     => 'nc-icon-outline-business_chart-bar-32',
												'size'     => 64,
												'colorHex' => '#0066CC',
											),
										),
										array(
											'type'  => 'Spacer',
											'value' => array(
												'height' => 15,
											),
										),
										array(
											'type'  => 'RichText',
											'value' => array(
												'text' => '<h3>' . __( 'Feature One', 'respira-for-wordpress' ) . '</h3><p>' . __( 'Description of your first amazing feature.', 'respira-for-wordpress' ) . '</p>',
											),
										),
									),
								),
								array(
									'type'  => 'Column',
									'value' => array(
										'width' => 33.33,
									),
									'items' => array(
										array(
											'type'  => 'Icon',
											'value' => array(
												'name'     => 'nc-icon-outline-business_chart-pie-36',
												'size'     => 64,
												'colorHex' => '#0066CC',
											),
										),
										array(
											'type'  => 'Spacer',
											'value' => array(
												'height' => 15,
											),
										),
										array(
											'type'  => 'RichText',
											'value' => array(
												'text' => '<h3>' . __( 'Feature Two', 'respira-for-wordpress' ) . '</h3><p>' . __( 'Description of your second amazing feature.', 'respira-for-wordpress' ) . '</p>',
											),
										),
									),
								),
								array(
									'type'  => 'Column',
									'value' => array(
										'width' => 33.34,
									),
									'items' => array(
										array(
											'type'  => 'Icon',
											'value' => array(
												'name'     => 'nc-icon-outline-business_bulb-63',
												'size'     => 64,
												'colorHex' => '#0066CC',
											),
										),
										array(
											'type'  => 'Spacer',
											'value' => array(
												'height' => 15,
											),
										),
										array(
											'type'  => 'RichText',
											'value' => array(
												'text' => '<h3>' . __( 'Feature Three', 'respira-for-wordpress' ) . '</h3><p>' . __( 'Description of your third amazing feature.', 'respira-for-wordpress' ) . '</p>',
											),
										),
									),
								),
							),
						),
					),
				),
			),
		),
		'call-to-action'         => array(
			'title'       => __( 'Call to Action', 'respira-for-wordpress' ),
			'description' => __( 'Centered CTA section with heading and button', 'respira-for-wordpress' ),
			'category'    => 'cta',
			'structure'   => array(
				array(
					'type'  => 'Section',
					'value' => array(
						'bgColorHex' => '#F5F5F5',
						'paddingTop' => 60,
						'paddingBottom' => 60,
					),
					'items' => array(
						array(
							'type'  => 'Row',
							'value' => array(),
							'columns' => array(
								array(
									'type'  => 'Column',
									'value' => array(
										'width' => 100,
									),
									'items' => array(
										array(
											'type'  => 'RichText',
											'value' => array(
												'text' => '<h2 style="text-align: center;">' . __( 'Ready to Get Started?', 'respira-for-wordpress' ) . '</h2>',
											),
										),
										array(
											'type'  => 'Spacer',
											'value' => array(
												'height' => 15,
											),
										),
										array(
											'type'  => 'RichText',
											'value' => array(
												'text' => '<p style="text-align: center; font-size: 16px;">' . __( 'Join thousands of satisfied customers today', 'respira-for-wordpress' ) . '</p>',
											),
										),
										array(
											'type'  => 'Spacer',
											'value' => array(
												'height' => 25,
											),
										),
										array(
											'type'  => 'Button',
											'value' => array(
												'text'       => __( 'Sign Up Now', 'respira-for-wordpress' ),
												'link'       => '#',
												'bgColorHex' => '#0066CC',
												'colorHex'   => '#FFFFFF',
											),
										),
									),
								),
							),
						),
					),
				),
			),
		),
		'two-column-content'     => array(
			'title'       => __( 'Two Column Content', 'respira-for-wordpress' ),
			'description' => __( 'Two-column layout with image and text', 'respira-for-wordpress' ),
			'category'    => 'content',
			'structure'   => array(
				array(
					'type'  => 'Section',
					'value' => array(
						'bgColorHex' => '#FFFFFF',
						'paddingTop' => 60,
						'paddingBottom' => 60,
					),
					'items' => array(
						array(
							'type'  => 'Row',
							'value' => array(),
							'columns' => array(
								array(
									'type'  => 'Column',
									'value' => array(
										'width' => 50,
									),
									'items' => array(
										array(
											'type'  => 'Image',
											'value' => array(
												'imageSrc'    => 'https://via.placeholder.com/600x400',
												'imageWidth'  => 600,
												'imageHeight' => 400,
												'alt'         => __( 'Placeholder image', 'respira-for-wordpress' ),
											),
										),
									),
								),
								array(
									'type'  => 'Column',
									'value' => array(
										'width' => 50,
									),
									'items' => array(
										array(
											'type'  => 'RichText',
											'value' => array(
												'text' => '<h2>' . __( 'About Our Service', 'respira-for-wordpress' ) . '</h2><p>' . __( 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.', 'respira-for-wordpress' ) . '</p><p>' . __( 'Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris.', 'respira-for-wordpress' ) . '</p>',
											),
										),
										array(
											'type'  => 'Spacer',
											'value' => array(
												'height' => 20,
											),
										),
										array(
											'type'  => 'Button',
											'value' => array(
												'text'       => __( 'Learn More', 'respira-for-wordpress' ),
												'link'       => '#',
												'bgColorHex' => '#0066CC',
												'colorHex'   => '#FFFFFF',
											),
										),
									),
								),
							),
						),
					),
				),
			),
		),
		'testimonial'            => array(
			'title'       => __( 'Testimonial', 'respira-for-wordpress' ),
			'description' => __( 'Centered testimonial with quote and author', 'respira-for-wordpress' ),
			'category'    => 'testimonials',
			'structure'   => array(
				array(
					'type'  => 'Section',
					'value' => array(
						'bgColorHex' => '#F9F9F9',
						'paddingTop' => 60,
						'paddingBottom' => 60,
					),
					'items' => array(
						array(
							'type'  => 'Row',
							'value' => array(),
							'columns' => array(
								array(
									'type'  => 'Column',
									'value' => array(
										'width' => 100,
									),
									'items' => array(
										array(
											'type'  => 'Icon',
											'value' => array(
												'name'     => 'nc-icon-outline-text_quote',
												'size'     => 48,
												'colorHex' => '#0066CC',
											),
										),
										array(
											'type'  => 'Spacer',
											'value' => array(
												'height' => 20,
											),
										),
										array(
											'type'  => 'RichText',
											'value' => array(
												'text' => '<p style="text-align: center; font-size: 18px; font-style: italic;">' . __( '"This service has completely transformed the way we do business. Highly recommended!"', 'respira-for-wordpress' ) . '</p>',
											),
										),
										array(
											'type'  => 'Spacer',
											'value' => array(
												'height' => 15,
											),
										),
										array(
											'type'  => 'RichText',
											'value' => array(
												'text' => '<p style="text-align: center; font-weight: bold;">' . __( 'Jane Doe', 'respira-for-wordpress' ) . '</p><p style="text-align: center;">' . __( 'CEO, Example Company', 'respira-for-wordpress' ) . '</p>',
											),
										),
									),
								),
							),
						),
					),
				),
			),
		),
		'pricing-table'          => array(
			'title'       => __( 'Pricing Table', 'respira-for-wordpress' ),
			'description' => __( 'Three-column pricing comparison', 'respira-for-wordpress' ),
			'category'    => 'pricing',
			'structure'   => array(
				array(
					'type'  => 'Section',
					'value' => array(
						'bgColorHex' => '#FFFFFF',
						'paddingTop' => 60,
						'paddingBottom' => 60,
					),
					'items' => array(
						array(
							'type'  => 'Row',
							'value' => array(),
							'columns' => array(
								array(
									'type'  => 'Column',
									'value' => array(
										'width' => 33.33,
									),
									'items' => array(
										array(
											'type'  => 'RichText',
											'value' => array(
												'text' => '<h3 style="text-align: center;">' . __( 'Basic', 'respira-for-wordpress' ) . '</h3><p style="text-align: center; font-size: 36px; font-weight: bold;">$9<span style="font-size: 16px;">/mo</span></p>',
											),
										),
										array(
											'type'  => 'Line',
											'value' => array(
												'borderColorHex' => '#E0E0E0',
											),
										),
										array(
											'type'  => 'RichText',
											'value' => array(
												'text' => '<ul><li>' . __( 'Feature 1', 'respira-for-wordpress' ) . '</li><li>' . __( 'Feature 2', 'respira-for-wordpress' ) . '</li><li>' . __( 'Feature 3', 'respira-for-wordpress' ) . '</li></ul>',
											),
										),
										array(
											'type'  => 'Button',
											'value' => array(
												'text'       => __( 'Choose Plan', 'respira-for-wordpress' ),
												'link'       => '#',
												'bgColorHex' => '#0066CC',
												'colorHex'   => '#FFFFFF',
											),
										),
									),
								),
								array(
									'type'  => 'Column',
									'value' => array(
										'width'      => 33.33,
										'bgColorHex' => '#0066CC',
									),
									'items' => array(
										array(
											'type'  => 'RichText',
											'value' => array(
												'text' => '<h3 style="text-align: center; color: #FFFFFF;">' . __( 'Pro', 'respira-for-wordpress' ) . '</h3><p style="text-align: center; font-size: 36px; font-weight: bold; color: #FFFFFF;">$29<span style="font-size: 16px;">/mo</span></p>',
											),
										),
										array(
											'type'  => 'Line',
											'value' => array(
												'borderColorHex' => '#FFFFFF',
											),
										),
										array(
											'type'  => 'RichText',
											'value' => array(
												'text' => '<ul style="color: #FFFFFF;"><li>' . __( 'All Basic features', 'respira-for-wordpress' ) . '</li><li>' . __( 'Feature 4', 'respira-for-wordpress' ) . '</li><li>' . __( 'Feature 5', 'respira-for-wordpress' ) . '</li></ul>',
											),
										),
										array(
											'type'  => 'Button',
											'value' => array(
												'text'       => __( 'Choose Plan', 'respira-for-wordpress' ),
												'link'       => '#',
												'bgColorHex' => '#FFFFFF',
												'colorHex'   => '#0066CC',
											),
										),
									),
								),
								array(
									'type'  => 'Column',
									'value' => array(
										'width' => 33.34,
									),
									'items' => array(
										array(
											'type'  => 'RichText',
											'value' => array(
												'text' => '<h3 style="text-align: center;">' . __( 'Enterprise', 'respira-for-wordpress' ) . '</h3><p style="text-align: center; font-size: 36px; font-weight: bold;">$99<span style="font-size: 16px;">/mo</span></p>',
											),
										),
										array(
											'type'  => 'Line',
											'value' => array(
												'borderColorHex' => '#E0E0E0',
											),
										),
										array(
											'type'  => 'RichText',
											'value' => array(
												'text' => '<ul><li>' . __( 'All Pro features', 'respira-for-wordpress' ) . '</li><li>' . __( 'Feature 6', 'respira-for-wordpress' ) . '</li><li>' . __( 'Feature 7', 'respira-for-wordpress' ) . '</li></ul>',
											),
										),
										array(
											'type'  => 'Button',
											'value' => array(
												'text'       => __( 'Contact Us', 'respira-for-wordpress' ),
												'link'       => '#',
												'bgColorHex' => '#0066CC',
												'colorHex'   => '#FFFFFF',
											),
										),
									),
								),
							),
						),
					),
				),
			),
		),
	);
}
