<?php
/**
 * Bricks Builder Intelligence Loader.
 *
 * Loads Bricks Builder Intelligence addon if available.
 *
 * @package    Respira_For_WordPress
 * @subpackage Respira_For_WordPress/includes/page-builders/bricks-intelligence
 * @since      1.4.0
 */

/**
 * Bricks Builder Intelligence loader class.
 *
 * @since 1.4.0
 */
class Respira_Bricks_Intelligence_Loader {

	/**
	 * Check if Bricks Builder Intelligence is available.
	 *
	 * @since 1.4.0
	 * @return bool True if Bricks Builder Intelligence is available.
	 */
	public static function is_available() {
		$loader_file = RESPIRA_PLUGIN_DIR . 'includes/bricks-intelligence/class-bricks-intelligence-loader.php';
		return file_exists( $loader_file );
	}

	/**
	 * Load Bricks Builder Intelligence.
	 *
	 * @since 1.4.0
	 * @return void
	 */
	public static function load() {
		$intelligence_dir = RESPIRA_PLUGIN_DIR . 'includes/bricks-intelligence/';

		// Load core Bricks Builder Intelligence classes.
		$classes = array(
			'class-bricks-element-registry.php',
			'class-bricks-element-schema.php',
			'class-bricks-validator.php',
		);

		foreach ( $classes as $class_file ) {
			$file_path = $intelligence_dir . $class_file;
			if ( file_exists( $file_path ) ) {
				require_once $file_path;
			}
		}

		// Load data files.
		$data_files = array(
			'bricks-patterns.php',
		);

		foreach ( $data_files as $data_file ) {
			$file_path = $intelligence_dir . $data_file;
			if ( file_exists( $file_path ) ) {
				require_once $file_path;
			}
		}
	}
}
