<?php
/**
 * Bricks Builder layout patterns library.
 *
 * Common layout patterns for Bricks Builder elements.
 *
 * @package    Respira_For_WordPress
 * @subpackage Respira_For_WordPress/includes/page-builders/bricks-intelligence
 * @since      1.4.0
 */

/**
 * Get Bricks Builder layout patterns.
 *
 * @since  1.4.0
 * @return array Array of patterns.
 */
function respira_get_bricks_patterns() {
	return array(
		'hero-section'          => array(
			'title'       => __( 'Hero Section', 'respira-for-wordpress' ),
			'description' => __( 'Full-width hero section with heading and CTA button', 'respira-for-wordpress' ),
			'category'    => 'headers',
			'structure'   => array(
				array(
					'id'       => 'container_' . uniqid(),
					'name'     => 'container',
					'settings' => array(
						'tag'         => 'section',
						'_width'      => '100%',
						'_padding'    => array( 'top' => '80px', 'bottom' => '80px' ),
						'_background' => array( 'color' => '#0066cc' ),
					),
					'children' => array(
						array(
							'id'       => 'heading_' . uniqid(),
							'name'     => 'heading',
							'settings' => array(
								'text'        => __( 'Welcome to Our Amazing Service', 'respira-for-wordpress' ),
								'tag'         => 'h1',
								'_typography' => array( 'fontSize' => '48px', 'textAlign' => 'center' ),
								'_color'      => '#ffffff',
							),
						),
						array(
							'id'       => 'text_' . uniqid(),
							'name'     => 'text',
							'settings' => array(
								'text'        => '<p>' . __( 'Your compelling tagline goes here', 'respira-for-wordpress' ) . '</p>',
								'_typography' => array( 'fontSize' => '18px', 'textAlign' => 'center' ),
								'_color'      => '#ffffff',
								'_margin'     => array( 'top' => '20px', 'bottom' => '30px' ),
							),
						),
						array(
							'id'       => 'button_' . uniqid(),
							'name'     => 'button',
							'settings' => array(
								'text'        => __( 'Get Started', 'respira-for-wordpress' ),
								'link'        => array( 'url' => '#', 'newTab' => false ),
								'_background' => array( 'color' => '#ffffff' ),
								'_typography' => array( 'color' => '#0066cc' ),
							),
						),
					),
				),
			),
		),
		'three-column-features' => array(
			'title'       => __( 'Three Column Features', 'respira-for-wordpress' ),
			'description' => __( 'Three-column layout with icon and text features', 'respira-for-wordpress' ),
			'category'    => 'content',
			'note'        => __( 'Use container with three nested containers in flexbox layout', 'respira-for-wordpress' ),
		),
		'call-to-action'        => array(
			'title'       => __( 'Call to Action', 'respira-for-wordpress' ),
			'description' => __( 'Centered CTA section with heading and button', 'respira-for-wordpress' ),
			'category'    => 'cta',
			'structure'   => array(
				array(
					'id'       => 'section_' . uniqid(),
					'name'     => 'section',
					'settings' => array(
						'_padding'    => array( 'top' => '60px', 'bottom' => '60px' ),
						'_background' => array( 'color' => '#f5f5f5' ),
					),
					'children' => array(
						array(
							'id'       => 'heading_' . uniqid(),
							'name'     => 'heading',
							'settings' => array(
								'text'        => __( 'Ready to Get Started?', 'respira-for-wordpress' ),
								'tag'         => 'h2',
								'_typography' => array( 'fontSize' => '36px', 'textAlign' => 'center' ),
							),
						),
						array(
							'id'       => 'text_' . uniqid(),
							'name'     => 'text',
							'settings' => array(
								'text'        => '<p>' . __( 'Join thousands of satisfied customers today', 'respira-for-wordpress' ) . '</p>',
								'_typography' => array( 'fontSize' => '16px', 'textAlign' => 'center' ),
								'_margin'     => array( 'top' => '15px', 'bottom' => '25px' ),
							),
						),
						array(
							'id'       => 'button_' . uniqid(),
							'name'     => 'button',
							'settings' => array(
								'text'        => __( 'Sign Up Now', 'respira-for-wordpress' ),
								'link'        => array( 'url' => '#', 'newTab' => false ),
								'_background' => array( 'color' => '#0066cc' ),
								'_typography' => array( 'color' => '#ffffff' ),
							),
						),
					),
				),
			),
		),
		'testimonial'           => array(
			'title'       => __( 'Testimonial', 'respira-for-wordpress' ),
			'description' => __( 'Centered testimonial with quote', 'respira-for-wordpress' ),
			'category'    => 'testimonials',
			'note'        => __( 'Use testimonials element or icon + text combination', 'respira-for-wordpress' ),
		),
		'pricing-table'         => array(
			'title'       => __( 'Pricing Table', 'respira-for-wordpress' ),
			'description' => __( 'Three-column pricing comparison', 'respira-for-wordpress' ),
			'category'    => 'pricing',
			'note'        => __( 'Use pricing-table elements in three column layout', 'respira-for-wordpress' ),
		),
		'image-with-text'       => array(
			'title'       => __( 'Image with Text', 'respira-for-wordpress' ),
			'description' => __( 'Two-column layout with image and text', 'respira-for-wordpress' ),
			'category'    => 'content',
			'note'        => __( 'Use flexbox container with image and text elements', 'respira-for-wordpress' ),
		),
	);
}

/**
 * Generate a unique Bricks element ID.
 *
 * @since  1.4.0
 * @param  string $prefix Optional prefix for the ID.
 * @return string Unique element ID.
 */
function respira_bricks_generate_id( $prefix = 'element' ) {
	return $prefix . '_' . uniqid();
}

/**
 * Create a Bricks element structure.
 *
 * @since  1.4.0
 * @param  string $name     Element name/type.
 * @param  array  $settings Element settings.
 * @param  array  $children Optional child elements.
 * @return array Element structure.
 */
function respira_bricks_create_element( $name, $settings = array(), $children = array() ) {
	$element = array(
		'id'       => respira_bricks_generate_id( $name ),
		'name'     => $name,
		'settings' => $settings,
	);

	if ( ! empty( $children ) ) {
		$element['children'] = $children;
	}

	return $element;
}
