<?php
/**
 * Beaver Builder Intelligence Loader.
 *
 * Loads Beaver Builder Intelligence addon if available.
 *
 * @package    Respira_For_WordPress
 * @subpackage Respira_For_WordPress/includes/page-builders/beaver-intelligence
 * @since      1.4.0
 */

/**
 * Beaver Builder Intelligence loader class.
 *
 * @since 1.4.0
 */
class Respira_Beaver_Intelligence_Loader {

	/**
	 * Check if Beaver Builder Intelligence is available.
	 *
	 * @since 1.4.0
	 * @return bool True if Beaver Builder Intelligence is available.
	 */
	public static function is_available() {
		$loader_file = RESPIRA_PLUGIN_DIR . 'includes/beaver-intelligence/class-beaver-intelligence-loader.php';
		return file_exists( $loader_file );
	}

	/**
	 * Load Beaver Builder Intelligence.
	 *
	 * @since 1.4.0
	 * @return void
	 */
	public static function load() {
		$intelligence_dir = RESPIRA_PLUGIN_DIR . 'includes/beaver-intelligence/';

		// Load core Beaver Builder Intelligence classes.
		$classes = array(
			'class-beaver-module-registry.php',
			'class-beaver-module-schema.php',
			'class-beaver-validator.php',
		);

		foreach ( $classes as $class_file ) {
			$file_path = $intelligence_dir . $class_file;
			if ( file_exists( $file_path ) ) {
				require_once $file_path;
			}
		}

		// Load data files.
		$data_files = array(
			'beaver-patterns.php',
		);

		foreach ( $data_files as $data_file ) {
			$file_path = $intelligence_dir . $data_file;
			if ( file_exists( $file_path ) ) {
				require_once $file_path;
			}
		}
	}
}
