<?php
/**
 * Start Here view.
 *
 * @package    Respira_For_WordPress
 * @subpackage Respira_For_WordPress/admin/views
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$context = Respira_Context::get_site_info();
$builder_info = Respira_Context::get_builder_info();
$license_info = Respira_License::get_license_info();
$is_pro = $license_info['is_pro'];
$license_status = $license_info['status'];
?>

<div class="wrap respira-admin-page">
	<?php require_once RESPIRA_PLUGIN_DIR . 'admin/views/partials/header.php'; ?>
	<div class="respira-page-body">

	<!-- License Required Notice -->
	<?php if ( ! $is_pro && 'trial' !== $license_status ) : ?>
		<div class="respira-section">
			<div class="respira-card" style="border-left: 4px solid #ef4444; background: rgba(239, 68, 68, 0.1); margin-bottom: 30px;">
				<div style="display: flex; align-items: center; gap: 16px; margin-bottom: 16px;">
					<span class="dashicons dashicons-lock" style="font-size: 32px; color: #ef4444;"></span>
					<div>
						<h3 style="margin: 0; color: #ef4444; font-size: 20px;"><?php esc_html_e( 'License Required', 'respira-for-wordpress' ); ?></h3>
						<p style="margin: 8px 0 0 0; color: #d1d5db;">
							<?php esc_html_e( 'You need to activate your license before you can connect your AI tool and use the API. Activate your license to unlock all features.', 'respira-for-wordpress' ); ?>
						</p>
					</div>
				</div>
				<p>
					<a href="<?php echo esc_url( admin_url( 'admin.php?page=respira-license' ) ); ?>" class="button button-primary button-large">
						<?php esc_html_e( 'Activate License →', 'respira-for-wordpress' ); ?>
					</a>
				</p>
			</div>
		</div>
	<?php endif; ?>

	<!-- Getting Started Section -->
	<div class="respira-section">
		<div class="respira-section-header">
			<h2><span class="dashicons dashicons-superhero"></span> <?php esc_html_e( 'Getting Started', 'respira-for-wordpress' ); ?></h2>
			<p><?php esc_html_e( 'Connect your AI coding assistant to your WordPress site. Choose your tool below:', 'respira-for-wordpress' ); ?></p>
		</div>
		
		<?php if ( ! $is_pro && 'trial' !== $license_status ) : ?>
			<div class="respira-card" style="border-left: 4px solid #f59e0b; background: rgba(245, 158, 11, 0.1); margin-bottom: 20px;">
				<p style="margin: 0; color: #fbbf24;">
					<strong><?php esc_html_e( 'Note:', 'respira-for-wordpress' ); ?></strong>
					<?php esc_html_e( 'The instructions below are for reference, but you must activate your license first to generate API keys and use the API.', 'respira-for-wordpress' ); ?>
				</p>
			</div>
		<?php endif; ?>

		<!-- AI Tool Tabs -->
		<div class="respira-tool-tabs">
			<button class="respira-tab-btn active" data-tool="cursor">
				<span class="dashicons dashicons-edit"></span> Cursor
			</button>
			<button class="respira-tab-btn" data-tool="claude">
				<span class="dashicons dashicons-admin-comments"></span> Claude Code
			</button>
			<button class="respira-tab-btn" data-tool="codex">
				<span class="dashicons dashicons-code-standards"></span> Codex
			</button>
		</div>

		<!-- Cursor Instructions -->
		<div class="respira-tool-content active" data-tool="cursor">
			<div class="respira-steps">
				<!-- Step 1 -->
				<div class="respira-step">
					<div class="respira-step-number">1</div>
					<div class="respira-step-content">
						<h3><?php esc_html_e( 'Activate Your License', 'respira-for-wordpress' ); ?></h3>
						<p><?php esc_html_e( 'Unlock the plugin by entering your Respira license key. You can find the key inside your respira.press dashboard.', 'respira-for-wordpress' ); ?></p>
						<a href="<?php echo esc_url( admin_url( 'admin.php?page=respira-license' ) ); ?>" class="button button-primary">
							<?php esc_html_e( 'Go to License →', 'respira-for-wordpress' ); ?>
						</a>
					</div>
				</div>

				<!-- Step 2 -->
				<div class="respira-step">
					<div class="respira-step-number">2</div>
					<div class="respira-step-content">
						<h3><?php esc_html_e( 'Generate Your API Key', 'respira-for-wordpress' ); ?></h3>
						<p><?php esc_html_e( 'Create a secure API key for Cursor/Claude to authenticate against your WordPress site.', 'respira-for-wordpress' ); ?></p>
						<a href="<?php echo esc_url( admin_url( 'admin.php?page=respira-api-keys' ) ); ?>" class="button button-primary">
							<?php esc_html_e( 'Go to API Keys →', 'respira-for-wordpress' ); ?>
						</a>
					</div>
				</div>

				<!-- Step 3 -->
				<div class="respira-step respira-step-wide">
					<div class="respira-step-number">3</div>
					<div class="respira-step-content">
						<h3><?php esc_html_e( 'Download Respira MCP Server', 'respira-for-wordpress' ); ?></h3>
						<p class="respira-step-subtext"><?php esc_html_e( 'This is the bridge between your AI assistant and WordPress.', 'respira-for-wordpress' ); ?></p>

						<div class="respira-code-block">
							<code># Download from respira.press/dashboard/downloads<br/># Extract the ZIP file to ~/.respira/</code>
						</div>
						<p class="respira-note">
							<span class="dashicons dashicons-info"></span>
							<a href="https://respira.press/dashboard/downloads" target="_blank"><?php esc_html_e( 'Download MCP Server from Dashboard →', 'respira-for-wordpress' ); ?></a>
						</p>

						<p class="respira-step-subtext"><?php esc_html_e( 'After download', 'respira-for-wordpress' ); ?></p>
						<div class="respira-code-block">
							<code># Extract the downloaded ZIP file<br/># Ensure dist/index.js exists at ~/.respira/dist/index.js</code>
						</div>
					</div>
				</div>

				<!-- Step 4 -->
				<div class="respira-step respira-step-wide">
					<div class="respira-step-number">4</div>
					<div class="respira-step-content">
						<h3><?php esc_html_e( 'Configure Cursor', 'respira-for-wordpress' ); ?></h3>
						<p><?php esc_html_e( 'Open Cursor → Settings → Features → Model Context Protocol and paste this configuration:', 'respira-for-wordpress' ); ?></p>
						<div class="respira-code-block respira-code-block-large">
							<pre><code>{
  "mcpServers": {
    "respira-wordpress": {
      "command": "node",
      "args": [
        "~/.respira/dist/index.js"
      ],
      "env": {
        "WORDPRESS_URL": "<?php echo esc_js( rest_url( RESPIRA_REST_NAMESPACE ) ); ?>",
        "WORDPRESS_API_KEY": "your-api-key-here"
      }
    }
  }
}</code></pre>
							<button class="button button-small respira-copy-btn respira-copy-config" data-copy='{"mcpServers":{"respira-wordpress":{"command":"node","args":["~/.respira/dist/index.js"],"env":{"WORDPRESS_URL":"<?php echo esc_js( rest_url( RESPIRA_REST_NAMESPACE ) ); ?>","WORDPRESS_API_KEY":"your-api-key-here"}}}}'>
								<?php esc_html_e( 'Copy Config', 'respira-for-wordpress' ); ?>
							</button>
						</div>
						<p class="respira-note">
							<span class="dashicons dashicons-info"></span>
							<?php esc_html_e( 'Replace "your-api-key-here" with your actual API key from Step 1. Restart Cursor after saving.', 'respira-for-wordpress' ); ?>
						</p>
					</div>
				</div>

				<!-- Step 5 -->
				<div class="respira-step">
					<div class="respira-step-number">5</div>
					<div class="respira-step-content">
						<h3><?php esc_html_e( 'Start Vibe Coding!', 'respira-for-wordpress' ); ?></h3>
						<p><?php esc_html_e( 'Restart Cursor and start chatting with AI to edit your WordPress site. Try commands like:', 'respira-for-wordpress' ); ?></p>
						<ul class="respira-command-examples">
							<li><code>"Create a new page called About Us"</code></li>
							<li><code>"Update the homepage hero section"</code></li>
							<li><code>"List all published posts"</code></li>
							<li><code>"Change the site tagline"</code></li>
						</ul>
					</div>
				</div>

				<!-- Step 6 -->
				<div class="respira-step">
					<div class="respira-step-number">6</div>
					<div class="respira-step-content">
						<h3><?php esc_html_e( 'Review & Approve Changes', 'respira-for-wordpress' ); ?></h3>
						<p><?php esc_html_e( 'All AI edits create duplicates for your review. Go to Approve Edits to review and approve changes before they go live.', 'respira-for-wordpress' ); ?></p>
						<a href="<?php echo esc_url( admin_url( 'admin.php?page=respira-approvals' ) ); ?>" class="button button-primary">
							<?php esc_html_e( 'Go to Approve Edits →', 'respira-for-wordpress' ); ?>
						</a>
					</div>
				</div>

				<!-- Step 7 -->
				<div class="respira-step respira-step-wide">
					<div class="respira-step-number">7</div>
					<div class="respira-step-content">
						<h3><?php esc_html_e( 'Join Our Community', 'respira-for-wordpress' ); ?></h3>
						<p><?php esc_html_e( 'Stay updated with the latest features, tips, and community discussions. Subscribe to our newsletter:', 'respira-for-wordpress' ); ?></p>
						<div style="margin-top: 20px; min-height: 100px;" data-supascribe-embed-id="431949586255" data-supascribe-subscribe></div>
						<script>
							(function() {
								var script = document.createElement('script');
								script.src = 'https://js.supascribe.com/v1/loader/OOst9ma4rJNtaBbonX8822Dtzuw1.js';
								script.async = true;
								document.head.appendChild(script);
							})();
						</script>
					</div>
				</div>
			</div>
		</div>

		<!-- Claude Code Instructions -->
		<div class="respira-tool-content" data-tool="claude">
			<div class="respira-steps">
				<!-- Step 1 -->
				<div class="respira-step">
					<div class="respira-step-number">1</div>
					<div class="respira-step-content">
						<h3><?php esc_html_e( 'Generate Your API Key', 'respira-for-wordpress' ); ?></h3>
						<p><?php esc_html_e( 'Create an API key to authenticate Claude Code with your WordPress site.', 'respira-for-wordpress' ); ?></p>
						<a href="<?php echo esc_url( admin_url( 'admin.php?page=respira-api-keys' ) ); ?>" class="button button-primary">
							<?php esc_html_e( 'Go to API Keys →', 'respira-for-wordpress' ); ?>
						</a>
					</div>
				</div>

				<!-- Step 2 -->
				<div class="respira-step">
					<div class="respira-step-number">2</div>
					<div class="respira-step-content">
						<h3><?php esc_html_e( 'Install Respira MCP Server', 'respira-for-wordpress' ); ?></h3>
						<p><?php esc_html_e( 'Choose one of these installation methods:', 'respira-for-wordpress' ); ?></p>
						
						<div style="margin: 15px 0;">
							<strong><?php esc_html_e( 'Option 1: Download from GitHub (Recommended)', 'respira-for-wordpress' ); ?></strong>
							<div class="respira-code-block" style="margin-top: 10px;">
								<code># Look for releases tagged "mcp-v*" (e.g., mcp-v1.0.0)<br/># Download the ZIP file and extract to ~/.respira/</code>
							</div>
							<p class="respira-note" style="margin-top: 10px;">
								<span class="dashicons dashicons-info"></span>
								<a href="https://github.com/webmyc/respira-wordpress/releases" target="_blank"><?php esc_html_e( 'View MCP Server Releases', 'respira-for-wordpress' ); ?></a>
								<?php esc_html_e( ' (look for releases starting with "mcp-v")', 'respira-for-wordpress' ); ?>
							</p>
						</div>

						<div style="margin: 15px 0;">
							<strong><?php esc_html_e( 'Option 2: Download from GitHub Releases', 'respira-for-wordpress' ); ?></strong>
							<p style="margin: 10px 0; color: #a0a0a0;">
								<?php esc_html_e( 'Since the repository is private, download the MCP server from GitHub releases:', 'respira-for-wordpress' ); ?>
							</p>
							<ol style="margin: 10px 0; padding-left: 20px; color: #a0a0a0;">
								<li><?php esc_html_e( 'Go to GitHub Releases (link above)', 'respira-for-wordpress' ); ?></li>
								<li><?php esc_html_e( 'Find the latest release with tag "mcp-v*"', 'respira-for-wordpress' ); ?></li>
								<li><?php esc_html_e( 'Download the "respira-wordpress-mcp-server-*.zip" file', 'respira-for-wordpress' ); ?></li>
								<li><?php esc_html_e( 'Extract the archive to a location on your computer', 'respira-for-wordpress' ); ?></li>
							</ol>
						</div>

						<div style="margin: 15px 0;">
							<strong><?php esc_html_e( 'After Installation:', 'respira-for-wordpress' ); ?></strong>
							<div class="respira-code-block" style="margin-top: 10px;">
								<code># Make sure dist/index.js exists at:<br/>~/.respira/dist/index.js</code>
							</div>
						</div>
					</div>
				</div>

				<!-- Step 3 -->
				<div class="respira-step">
					<div class="respira-step-number">3</div>
					<div class="respira-step-content">
						<h3><?php esc_html_e( 'Configure Claude Desktop', 'respira-for-wordpress' ); ?></h3>
						<p><?php esc_html_e( 'Open your Claude Desktop configuration file and add the MCP server:', 'respira-for-wordpress' ); ?></p>
						<div class="respira-code-block" style="margin-top: 10px;">
							<code><strong>macOS:</strong> ~/Library/Application Support/Claude/claude_desktop_config.json</code>
						</div>
						<div class="respira-code-block" style="margin-top: 10px;">
							<code><strong>Windows:</strong> %APPDATA%\Claude\claude_desktop_config.json</code>
						</div>
						<div class="respira-code-block" style="margin-top: 10px;">
							<code><strong>Linux:</strong> ~/.config/Claude/claude_desktop_config.json</code>
						</div>
						<div class="respira-code-block respira-code-block-large" style="margin-top: 15px;">
							<pre><code>{
  "mcpServers": {
    "respira-wordpress": {
      "command": "node",
      "args": [
        "~/.respira/dist/index.js"
      ],
      "env": {
        "WORDPRESS_URL": "<?php echo esc_js( rest_url( RESPIRA_REST_NAMESPACE ) ); ?>",
        "WORDPRESS_API_KEY": "your-api-key-here"
      }
    }
  }
}</code></pre>
							<button class="button button-small respira-copy-btn respira-copy-config" data-copy='{"mcpServers":{"respira-wordpress":{"command":"node","args":["~/.respira/dist/index.js"],"env":{"WORDPRESS_URL":"<?php echo esc_js( rest_url( RESPIRA_REST_NAMESPACE ) ); ?>","WORDPRESS_API_KEY":"your-api-key-here"}}}}'>
								<?php esc_html_e( 'Copy Config', 'respira-for-wordpress' ); ?>
							</button>
						</div>
						<p class="respira-note">
							<span class="dashicons dashicons-info"></span>
							<?php esc_html_e( 'Replace "your-api-key-here" with your actual API key from Step 1. Restart Claude Desktop after saving.', 'respira-for-wordpress' ); ?>
						</p>
					</div>
				</div>

				<!-- Step 4 -->
				<div class="respira-step">
					<div class="respira-step-number">4</div>
					<div class="respira-step-content">
						<h3><?php esc_html_e( 'Start Vibe Coding!', 'respira-for-wordpress' ); ?></h3>
						<p><?php esc_html_e( 'Restart Claude Desktop and start chatting with AI to edit your WordPress site. Try commands like:', 'respira-for-wordpress' ); ?></p>
						<ul class="respira-command-examples">
							<li><code>"Create a new page called About Us"</code></li>
							<li><code>"Update the homepage hero section"</code></li>
							<li><code>"List all published posts"</code></li>
							<li><code>"Change the site tagline"</code></li>
						</ul>
					</div>
				</div>
			</div>
		</div>

		<!-- Codex Instructions -->
		<div class="respira-tool-content" data-tool="codex">
			<div class="respira-steps">
				<!-- Step 1 -->
				<div class="respira-step">
					<div class="respira-step-number">1</div>
					<div class="respira-step-content">
						<h3><?php esc_html_e( 'Generate Your API Key', 'respira-for-wordpress' ); ?></h3>
						<p><?php esc_html_e( 'Create an API key to authenticate Codex with your WordPress site.', 'respira-for-wordpress' ); ?></p>
						<a href="<?php echo esc_url( admin_url( 'admin.php?page=respira-api-keys' ) ); ?>" class="button button-primary">
							<?php esc_html_e( 'Go to API Keys →', 'respira-for-wordpress' ); ?>
						</a>
					</div>
				</div>

				<!-- Step 2 -->
				<div class="respira-step">
					<div class="respira-step-number">2</div>
					<div class="respira-step-content">
						<h3><?php esc_html_e( 'Install Respira MCP Server', 'respira-for-wordpress' ); ?></h3>
						<p><?php esc_html_e( 'Choose one of these installation methods:', 'respira-for-wordpress' ); ?></p>
						
						<div style="margin: 15px 0;">
							<strong><?php esc_html_e( 'Option 1: Download from GitHub (Recommended)', 'respira-for-wordpress' ); ?></strong>
							<div class="respira-code-block" style="margin-top: 10px;">
								<code># Look for releases tagged "mcp-v*" (e.g., mcp-v1.0.0)<br/># Download the ZIP file and extract to ~/.respira/</code>
							</div>
							<p class="respira-note" style="margin-top: 10px;">
								<span class="dashicons dashicons-info"></span>
								<a href="https://github.com/webmyc/respira-wordpress/releases" target="_blank"><?php esc_html_e( 'View MCP Server Releases', 'respira-for-wordpress' ); ?></a>
								<?php esc_html_e( ' (look for releases starting with "mcp-v")', 'respira-for-wordpress' ); ?>
							</p>
						</div>

						<div style="margin: 15px 0;">
							<strong><?php esc_html_e( 'Option 2: Download from GitHub Releases', 'respira-for-wordpress' ); ?></strong>
							<p style="margin: 10px 0; color: #a0a0a0;">
								<?php esc_html_e( 'Since the repository is private, download the MCP server from GitHub releases:', 'respira-for-wordpress' ); ?>
							</p>
							<ol style="margin: 10px 0; padding-left: 20px; color: #a0a0a0;">
								<li><?php esc_html_e( 'Go to GitHub Releases (link above)', 'respira-for-wordpress' ); ?></li>
								<li><?php esc_html_e( 'Find the latest release with tag "mcp-v*"', 'respira-for-wordpress' ); ?></li>
								<li><?php esc_html_e( 'Download the "respira-wordpress-mcp-server-*.zip" file', 'respira-for-wordpress' ); ?></li>
								<li><?php esc_html_e( 'Extract the archive to a location on your computer', 'respira-for-wordpress' ); ?></li>
							</ol>
						</div>

						<div style="margin: 15px 0;">
							<strong><?php esc_html_e( 'After Installation:', 'respira-for-wordpress' ); ?></strong>
							<div class="respira-code-block" style="margin-top: 10px;">
								<code># Make sure dist/index.js exists at:<br/>~/.respira/dist/index.js</code>
							</div>
						</div>
					</div>
				</div>

				<!-- Step 3 -->
				<div class="respira-step">
					<div class="respira-step-number">3</div>
					<div class="respira-step-content">
						<h3><?php esc_html_e( 'Configure Codex', 'respira-for-wordpress' ); ?></h3>
						<p><?php esc_html_e( 'Codex uses the same MCP configuration as Cursor. Open Codex Settings → MCP and add:', 'respira-for-wordpress' ); ?></p>
						<div class="respira-code-block respira-code-block-large">
							<pre><code>{
  "mcpServers": {
    "respira-wordpress": {
      "command": "node",
      "args": [
        "~/.respira/dist/index.js"
      ],
      "env": {
        "WORDPRESS_URL": "<?php echo esc_js( rest_url( RESPIRA_REST_NAMESPACE ) ); ?>",
        "WORDPRESS_API_KEY": "your-api-key-here"
      }
    }
  }
}</code></pre>
							<button class="button button-small respira-copy-btn respira-copy-config" data-copy='{"mcpServers":{"respira-wordpress":{"command":"node","args":["~/.respira/dist/index.js"],"env":{"WORDPRESS_URL":"<?php echo esc_js( rest_url( RESPIRA_REST_NAMESPACE ) ); ?>","WORDPRESS_API_KEY":"your-api-key-here"}}}}'>
								<?php esc_html_e( 'Copy Config', 'respira-for-wordpress' ); ?>
							</button>
						</div>
						<p class="respira-note">
							<span class="dashicons dashicons-info"></span>
							<?php esc_html_e( 'Replace "your-api-key-here" with your actual API key from Step 1. Restart Codex after saving.', 'respira-for-wordpress' ); ?>
						</p>
					</div>
				</div>

				<!-- Step 4 -->
				<div class="respira-step">
					<div class="respira-step-number">4</div>
					<div class="respira-step-content">
						<h3><?php esc_html_e( 'Start Vibe Coding!', 'respira-for-wordpress' ); ?></h3>
						<p><?php esc_html_e( 'Restart Codex and start chatting with AI to edit your WordPress site. Try commands like:', 'respira-for-wordpress' ); ?></p>
						<ul class="respira-command-examples">
							<li><code>"Create a new page called About Us"</code></li>
							<li><code>"Update the homepage hero section"</code></li>
							<li><code>"List all published posts"</code></li>
							<li><code>"Change the site tagline"</code></li>
						</ul>
					</div>
				</div>
			</div>
		</div>
	</div>

	<!-- Personal Onboarding Section -->
	<div class="respira-section" style="margin-top: 40px;">
		<div class="respira-onboarding-card">
			<div class="respira-onboarding-content">
				<div style="display: flex; align-items: center; gap: 12px;">
					<h3><?php esc_html_e( 'Does all of this feel like too much to handle on your own?', 'respira-for-wordpress' ); ?></h3>
					<span class="respira-onboarding-pill"><?php esc_html_e( 'POPULAR', 'respira-for-wordpress' ); ?></span>
				</div>
				<p class="respira-onboarding-subtitle"><?php esc_html_e( 'Personal Onboarding', 'respira-for-wordpress' ); ?></p>
				<p class="respira-onboarding-price">€300</p>
				<div class="respira-onboarding-highlight">
					<p style="font-weight: 600; margin: 0 0 6px 0;"><?php esc_html_e( 'New to vibe coding?', 'respira-for-wordpress' ); ?></p>
					<p style="margin: 0;"><?php esc_html_e( 'A private 1:1 session where you share your screen and Mihai guides you through everything. Perfect if you want a co-pilot for your first Respira setup.', 'respira-for-wordpress' ); ?></p>
				</div>
				<ul class="respira-onboarding-benefits">
					<li><span class="check">✓</span><span><?php esc_html_e( '2-hour live Zoom session with step-by-step guidance', 'respira-for-wordpress' ); ?></span></li>
					<li><span class="check">✓</span><span><?php esc_html_e( 'Full recording plus summary & transcript for reference', 'respira-for-wordpress' ); ?></span></li>
					<li><span class="check">✓</span><span><?php esc_html_e( 'Customized checklist tailored to your WordPress stack', 'respira-for-wordpress' ); ?></span></li>
					<li><span class="check">✓</span><span><?php esc_html_e( 'Personalized onboarding — we set everything up together', 'respira-for-wordpress' ); ?></span></li>
				</ul>
			</div>
			<div class="respira-onboarding-cta">
				<a 
					href="https://cal.com/mihai-love/respira-personal-onboarding" 
					target="_blank" 
					rel="noopener noreferrer"
					class="button respira-primary-btn"
				>
					<?php esc_html_e( 'Book Your Session', 'respira-for-wordpress' ); ?>
				</a>
				<p class="respira-onboarding-note">
					<?php esc_html_e( 'One-time payment · Everything listed above is included', 'respira-for-wordpress' ); ?>
				</p>
			</div>
		</div>
	</div>

	</div>

	<?php require_once RESPIRA_PLUGIN_DIR . 'admin/views/partials/footer.php'; ?>
</div>
