<?php
/**
 * Approvals view.
 *
 * @package    Respira_For_WordPress
 * @subpackage Respira_For_WordPress/admin/views
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Get all Respira duplicates (pages and posts).
$args = array(
	'post_type'      => array( 'page', 'post' ),
	'post_status'    => 'any',
	'posts_per_page' => -1,
	'meta_query'     => array(
		array(
			'key'     => '_respira_duplicate',
			'value'   => true,
			'compare' => '=',
		),
	),
);

$duplicates_query = new WP_Query( $args );
$duplicates = $duplicates_query->posts;

// Group duplicates by original ID.
$originals_with_duplicates = array();
foreach ( $duplicates as $duplicate ) {
	$original_id = get_post_meta( $duplicate->ID, '_respira_original_id', true );
	if ( $original_id ) {
		if ( ! isset( $originals_with_duplicates[ $original_id ] ) ) {
			$original = get_post( $original_id );
			if ( $original ) {
				$originals_with_duplicates[ $original_id ] = array(
					'original'   => $original,
					'duplicates' => array(),
				);
			}
		}
		if ( isset( $originals_with_duplicates[ $original_id ] ) ) {
			$originals_with_duplicates[ $original_id ]['duplicates'][] = $duplicate;
		}
	}
}
?>

<div class="wrap respira-admin-page">
	<?php require_once RESPIRA_PLUGIN_DIR . 'admin/views/partials/header.php'; ?>
	<div class="respira-page-body">

	<!-- Explanation Section -->
	<div class="respira-section" style="margin-bottom: 20px;">
		<div class="respira-section-header">
			<h2><span class="dashicons dashicons-info"></span> <?php esc_html_e( 'How Approve Edits Works', 'respira-for-wordpress' ); ?></h2>
		</div>
		<div class="respira-section-content" style="padding: 20px; background: #242938; border-radius: 8px; margin-top: 15px;">
			<div style="display: grid; grid-template-columns: 1fr 1fr; gap: 20px; margin-bottom: 15px;">
				<div style="padding: 15px; background: rgba(16, 185, 129, 0.1); border: 1px solid rgba(16, 185, 129, 0.3); border-radius: 6px;">
					<h3 style="color: #10b981; margin-top: 0; display: flex; align-items: center; gap: 8px;">
						<span class="dashicons dashicons-yes-alt"></span>
						<?php esc_html_e( 'Approve', 'respira-for-wordpress' ); ?>
					</h3>
					<p style="color: #d1d5db; margin: 0;">
						<?php esc_html_e( 'Approving a duplicate will:', 'respira-for-wordpress' ); ?>
					</p>
					<ul style="color: #d1d5db; margin: 10px 0 0 20px;">
						<li><?php esc_html_e( 'Publish the AI-edited duplicate with the original URL', 'respira-for-wordpress' ); ?></li>
						<li><?php esc_html_e( 'Unpublish the original and rename it with "-old" suffix', 'respira-for-wordpress' ); ?></li>
						<li><?php esc_html_e( 'Make the new version live on your website', 'respira-for-wordpress' ); ?></li>
					</ul>
				</div>
				<div style="padding: 15px; background: rgba(239, 68, 68, 0.1); border: 1px solid rgba(239, 68, 68, 0.3); border-radius: 6px;">
					<h3 style="color: #ef4444; margin-top: 0; display: flex; align-items: center; gap: 8px;">
						<span class="dashicons dashicons-dismiss"></span>
						<?php esc_html_e( 'Reject', 'respira-for-wordpress' ); ?>
					</h3>
					<p style="color: #d1d5db; margin: 0;">
						<?php esc_html_e( 'Rejecting a duplicate will:', 'respira-for-wordpress' ); ?>
					</p>
					<ul style="color: #d1d5db; margin: 10px 0 0 20px;">
						<li><?php esc_html_e( 'Permanently delete the AI-edited duplicate', 'respira-for-wordpress' ); ?></li>
						<li><?php esc_html_e( 'Keep the original page unchanged', 'respira-for-wordpress' ); ?></li>
						<li><?php esc_html_e( 'Discard all AI changes', 'respira-for-wordpress' ); ?></li>
					</ul>
				</div>
			</div>
			<p style="color: #9ca3af; font-size: 13px; margin: 0;">
				<span class="dashicons dashicons-lightbulb" style="color: #fbbf24;"></span>
				<strong><?php esc_html_e( 'Tip:', 'respira-for-wordpress' ); ?></strong>
				<?php esc_html_e( 'Always preview both versions before approving or rejecting to ensure the changes are what you expect.', 'respira-for-wordpress' ); ?>
			</p>
		</div>
	</div>

	<?php if ( empty( $originals_with_duplicates ) ) : ?>
		<div class="respira-card">
			<p><?php esc_html_e( 'No duplicate pages or posts waiting for approval.', 'respira-for-wordpress' ); ?></p>
			<p><?php esc_html_e( 'When AI creates duplicates of your pages or posts, they will appear here for you to review and approve.', 'respira-for-wordpress' ); ?></p>
		</div>
	<?php else : ?>
		<div class="respira-approvals-container">
			<?php foreach ( $originals_with_duplicates as $data ) : ?>
				<?php
				$original = $data['original'];
				$duplicates_list = $data['duplicates'];
				$post_type_label = 'page' === $original->post_type ? __( 'Page', 'respira-for-wordpress' ) : __( 'Post', 'respira-for-wordpress' );
				?>
				<div class="respira-approval-group">
					<div class="respira-approval-columns">
						<!-- Original Column -->
						<div class="respira-approval-column respira-original-column">
							<h2 class="respira-column-title">
								<span class="dashicons dashicons-admin-page"></span>
								<?php echo esc_html( $post_type_label ); ?>: <?php echo esc_html( $original->post_title ); ?>
							</h2>
							<div class="respira-approval-card respira-original-card">
								<div class="respira-card-header">
									<h3><?php echo esc_html( $original->post_title ); ?></h3>
									<span class="respira-status-badge respira-status-<?php echo esc_attr( $original->post_status ); ?>">
										<?php echo esc_html( ucfirst( $original->post_status ) ); ?>
									</span>
								</div>
								<div class="respira-card-body-wrapper">
									<div class="respira-card-content">
										<p class="respira-meta">
											<strong><?php esc_html_e( 'ID:', 'respira-for-wordpress' ); ?></strong> <?php echo esc_html( $original->ID ); ?><br/>
											<strong><?php esc_html_e( 'Slug:', 'respira-for-wordpress' ); ?></strong> <?php echo esc_html( $original->post_name ); ?><br/>
											<strong><?php esc_html_e( 'Status:', 'respira-for-wordpress' ); ?></strong> <?php echo esc_html( ucfirst( $original->post_status ) ); ?>
										</p>
										<?php
										$original_content = strip_tags( $original->post_content );
										$word_count = str_word_count( $original_content );
										$char_count = strlen( $original_content );
										$size_kb = round( strlen( $original->post_content ) / 1024, 2 );
										?>
										<div class="respira-stats">
											<p class="respira-meta">
												<strong><?php esc_html_e( 'Word Count:', 'respira-for-wordpress' ); ?></strong> <?php echo esc_html( number_format( $word_count ) ); ?><br/>
												<strong><?php esc_html_e( 'Character Count:', 'respira-for-wordpress' ); ?></strong> <?php echo esc_html( number_format( $char_count ) ); ?><br/>
												<strong><?php esc_html_e( 'Estimated Size:', 'respira-for-wordpress' ); ?></strong> <?php echo esc_html( $size_kb ); ?> KB
											</p>
										</div>
									</div>
									<div class="respira-card-actions">
										<a href="<?php echo esc_url( get_permalink( $original->ID ) ); ?>" target="_blank" class="button button-small">
											<span class="dashicons dashicons-visibility"></span> <?php esc_html_e( 'View', 'respira-for-wordpress' ); ?>
										</a>
										<a href="<?php echo esc_url( get_edit_post_link( $original->ID ) ); ?>" class="button button-small">
											<span class="dashicons dashicons-edit"></span> <?php esc_html_e( 'Edit', 'respira-for-wordpress' ); ?>
										</a>
									</div>
								</div>
							</div>
						</div>

						<!-- Duplicates Column -->
						<div class="respira-approval-column respira-duplicates-column">
							<h2 class="respira-column-title">
								<span class="dashicons dashicons-admin-page"></span>
								<?php esc_html_e( 'AI-Enhanced Duplicates', 'respira-for-wordpress' ); ?>
								<span class="respira-count-badge"><?php echo esc_html( count( $duplicates_list ) ); ?></span>
							</h2>
							<?php foreach ( $duplicates_list as $duplicate ) : ?>
								<div class="respira-approval-card respira-duplicate-card" data-duplicate-id="<?php echo esc_attr( $duplicate->ID ); ?>">
									<div class="respira-card-header">
										<h3><?php echo esc_html( $duplicate->post_title ); ?></h3>
										<span class="respira-status-badge respira-status-<?php echo esc_attr( $duplicate->post_status ); ?>">
											<?php echo esc_html( ucfirst( $duplicate->post_status ) ); ?>
										</span>
									</div>
									<div class="respira-card-body-wrapper">
										<div class="respira-card-content">
											<p class="respira-meta">
												<strong><?php esc_html_e( 'ID:', 'respira-for-wordpress' ); ?></strong> <?php echo esc_html( $duplicate->ID ); ?><br/>
												<strong><?php esc_html_e( 'Slug:', 'respira-for-wordpress' ); ?></strong> <?php echo esc_html( $duplicate->post_name ); ?><br/>
												<strong><?php esc_html_e( 'Status:', 'respira-for-wordpress' ); ?></strong> <?php echo esc_html( ucfirst( $duplicate->post_status ) ); ?>
											</p>
											<?php
											$duplicated_at = get_post_meta( $duplicate->ID, '_respira_duplicated_at', true );
											if ( $duplicated_at ) :
												?>
												<p class="respira-meta">
													<strong><?php esc_html_e( 'Created:', 'respira-for-wordpress' ); ?></strong>
													<?php echo esc_html( mysql2date( get_option( 'date_format' ) . ' ' . get_option( 'time_format' ), $duplicated_at ) ); ?>
												</p>
											<?php endif; ?>
											<?php
											$duplicate_content = strip_tags( $duplicate->post_content );
											$word_count = str_word_count( $duplicate_content );
											$char_count = strlen( $duplicate_content );
											$size_kb = round( strlen( $duplicate->post_content ) / 1024, 2 );
											?>
											<div class="respira-stats">
												<p class="respira-meta">
													<strong><?php esc_html_e( 'Word Count:', 'respira-for-wordpress' ); ?></strong> <?php echo esc_html( number_format( $word_count ) ); ?><br/>
													<strong><?php esc_html_e( 'Character Count:', 'respira-for-wordpress' ); ?></strong> <?php echo esc_html( number_format( $char_count ) ); ?><br/>
													<strong><?php esc_html_e( 'Estimated Size:', 'respira-for-wordpress' ); ?></strong> <?php echo esc_html( $size_kb ); ?> KB
												</p>
											</div>
										</div>
										<div class="respira-card-actions">
											<a href="<?php echo esc_url( get_permalink( $duplicate->ID ) ); ?>" target="_blank" class="button button-small">
												<span class="dashicons dashicons-visibility"></span> <?php esc_html_e( 'View', 'respira-for-wordpress' ); ?>
											</a>
											<a href="<?php echo esc_url( get_edit_post_link( $duplicate->ID ) ); ?>" class="button button-small">
												<span class="dashicons dashicons-edit"></span> <?php esc_html_e( 'Edit', 'respira-for-wordpress' ); ?>
											</a>
											<button type="button" class="button button-primary button-small respira-approve-btn" data-duplicate-id="<?php echo esc_attr( $duplicate->ID ); ?>" data-original-id="<?php echo esc_attr( $original->ID ); ?>">
												<span class="dashicons dashicons-yes-alt"></span> <?php esc_html_e( 'Approve', 'respira-for-wordpress' ); ?>
											</button>
											<button type="button" class="button button-small respira-reject-btn" data-duplicate-id="<?php echo esc_attr( $duplicate->ID ); ?>" style="background: #ef4444; color: white; border-color: #ef4444;">
												<span class="dashicons dashicons-dismiss"></span> <?php esc_html_e( 'Reject', 'respira-for-wordpress' ); ?>
											</button>
										</div>
									</div>
									<div class="respira-approval-message" style="display: none;"></div>
								</div>
							<?php endforeach; ?>
						</div>
					</div>
				</div>
			<?php endforeach; ?>
		</div>
	<?php endif; ?>
</div>

<!-- Testimonial Modal -->
<div id="respira-testimonial-modal" class="respira-modal" style="display: none;">
	<div class="respira-modal-overlay"></div>
	<div class="respira-modal-content">
		<div class="respira-modal-header">
			<h2><?php esc_html_e( 'Share Your Experience', 'respira-for-wordpress' ); ?></h2>
			<button type="button" class="respira-modal-close" aria-label="<?php esc_attr_e( 'Close', 'respira-for-wordpress' ); ?>">
				<span class="dashicons dashicons-no-alt"></span>
			</button>
		</div>
		<div class="respira-modal-body">
			<p style="color: #d1d5db; margin-bottom: 20px;">
				<?php esc_html_e( 'We\'d love to hear about your experience with Respira! Your feedback helps us improve.', 'respira-for-wordpress' ); ?>
			</p>
			<form id="respira-testimonial-form">
				<div class="respira-form-group">
					<label for="testimonial-name">
						<?php esc_html_e( 'Your Name', 'respira-for-wordpress' ); ?>
						<span class="required">*</span>
					</label>
					<input type="text" id="testimonial-name" name="name" required class="respira-form-input" />
				</div>
				<div class="respira-form-group">
					<label for="testimonial-text">
						<?php esc_html_e( 'Your Testimonial', 'respira-for-wordpress' ); ?>
						<span class="required">*</span>
					</label>
					<textarea id="testimonial-text" name="testimonial" rows="5" required class="respira-form-input"></textarea>
				</div>
				<div class="respira-form-group">
					<label for="testimonial-rating">
						<?php esc_html_e( 'Rating', 'respira-for-wordpress' ); ?>
						<span class="required">*</span>
					</label>
					<div class="respira-rating-stars">
						<?php for ( $i = 1; $i <= 5; $i++ ) : ?>
							<button type="button" class="respira-star-btn" data-rating="<?php echo esc_attr( $i ); ?>" aria-label="<?php echo esc_attr( sprintf( __( '%d stars', 'respira-for-wordpress' ), $i ) ); ?>">
								<span class="dashicons dashicons-star-empty"></span>
							</button>
						<?php endfor; ?>
					</div>
					<input type="hidden" id="testimonial-rating" name="rating" value="" required />
				</div>
				<div class="respira-form-group">
					<label>
						<input type="checkbox" name="anonymous_name" value="1" />
						<?php esc_html_e( 'Keep my name anonymous', 'respira-for-wordpress' ); ?>
					</label>
				</div>
				<div class="respira-form-group">
					<label>
						<input type="checkbox" name="anonymous_website" value="1" />
						<?php esc_html_e( 'Keep my website anonymous', 'respira-for-wordpress' ); ?>
					</label>
				</div>
				<input type="hidden" name="website_url" value="<?php echo esc_attr( get_site_url() ); ?>" />
				<div class="respira-form-actions">
					<button type="button" class="button respira-modal-close">
						<?php esc_html_e( 'Skip', 'respira-for-wordpress' ); ?>
					</button>
					<button type="submit" class="button button-primary">
						<?php esc_html_e( 'Submit Testimonial', 'respira-for-wordpress' ); ?>
					</button>
				</div>
			</form>
			<div id="respira-testimonial-message" style="display: none; margin-top: 15px;"></div>
		</div>
	</div>
</div>

<script type="text/javascript">
jQuery(document).ready(function($) {
	// Ensure respira_admin object exists (fallback if script not enqueued).
	if (typeof respira_admin === 'undefined') {
		window.respira_admin = {
			ajax_url: '<?php echo esc_js( admin_url( 'admin-ajax.php' ) ); ?>',
			nonce: '<?php echo esc_js( wp_create_nonce( 'respira_admin_nonce' ) ); ?>'
		};
	}

	// Approve button handler
	$('.respira-approve-btn').on('click', function(e) {
		e.preventDefault();
		var $btn = $(this);
		var duplicateId = $btn.data('duplicate-id');
		var originalId = $btn.data('original-id');
		var $card = $btn.closest('.respira-duplicate-card');
		var $message = $card.find('.respira-approval-message');

		// Disable button and show loading.
		$btn.prop('disabled', true).text('<?php echo esc_js( __( 'Approving...', 'respira-for-wordpress' ) ); ?>');

		// Make AJAX request.
		$.ajax({
			url: respira_admin.ajax_url,
			type: 'POST',
			data: {
				action: 'respira_approve_duplicate',
				nonce: respira_admin.nonce,
				duplicate_id: duplicateId,
				original_id: originalId
			},
			success: function(response) {
				if (response.success) {
					// Trigger confetti animation
					if (typeof confetti !== 'undefined') {
						confetti({
							particleCount: 100,
							spread: 70,
							origin: { y: 0.6 }
						});
					}
					
					$message.removeClass('error').addClass('success').html('<span class="dashicons dashicons-yes-alt"></span> ' + response.data.message).show();
					$btn.hide();
					$card.find('.respira-reject-btn').hide();
					
					// Show testimonial modal
					$('#respira-testimonial-modal').fadeIn(300);
					
					// Don't reload immediately - wait for user to submit or skip testimonial
				} else {
					$message.removeClass('success').addClass('error').html('<span class="dashicons dashicons-warning"></span> ' + (response.data.message || '<?php echo esc_js( __( 'An error occurred.', 'respira-for-wordpress' ) ); ?>')).show();
					$btn.prop('disabled', false).html('<span class="dashicons dashicons-yes-alt"></span> <?php echo esc_js( __( 'Approve', 'respira-for-wordpress' ) ); ?>');
				}
			},
			error: function() {
				$message.removeClass('success').addClass('error').html('<span class="dashicons dashicons-warning"></span> <?php echo esc_js( __( 'Network error. Please try again.', 'respira-for-wordpress' ) ); ?>').show();
				$btn.prop('disabled', false).html('<span class="dashicons dashicons-yes-alt"></span> <?php echo esc_js( __( 'Approve', 'respira-for-wordpress' ) ); ?>');
			}
		});
	});

	// Reject button handler
	$('.respira-reject-btn').on('click', function(e) {
		e.preventDefault();
		
		// Confirm before rejecting
		if (!confirm('<?php echo esc_js( __( 'Are you sure you want to reject and permanently delete this duplicate? This action cannot be undone.', 'respira-for-wordpress' ) ); ?>')) {
			return;
		}

		var $btn = $(this);
		var duplicateId = $btn.data('duplicate-id');
		var $card = $btn.closest('.respira-duplicate-card');
		var $message = $card.find('.respira-approval-message');

		// Disable button and show loading.
		$btn.prop('disabled', true).text('<?php echo esc_js( __( 'Rejecting...', 'respira-for-wordpress' ) ); ?>');

		// Make AJAX request.
		$.ajax({
			url: respira_admin.ajax_url,
			type: 'POST',
			data: {
				action: 'respira_reject_duplicate',
				nonce: respira_admin.nonce,
				duplicate_id: duplicateId
			},
			success: function(response) {
				if (response.success) {
					$message.removeClass('error').addClass('success').html('<span class="dashicons dashicons-yes-alt"></span> ' + response.data.message).show();
					$btn.hide();
					$card.find('.respira-approve-btn').hide();
					
					// Reload page after 2 seconds to show updated state.
					setTimeout(function() {
						location.reload();
					}, 2000);
				} else {
					$message.removeClass('success').addClass('error').html('<span class="dashicons dashicons-warning"></span> ' + (response.data.message || '<?php echo esc_js( __( 'An error occurred.', 'respira-for-wordpress' ) ); ?>')).show();
					$btn.prop('disabled', false).html('<span class="dashicons dashicons-dismiss"></span> <?php echo esc_js( __( 'Reject', 'respira-for-wordpress' ) ); ?>');
				}
			},
			error: function() {
				$message.removeClass('success').addClass('error').html('<span class="dashicons dashicons-warning"></span> <?php echo esc_js( __( 'Network error. Please try again.', 'respira-for-wordpress' ) ); ?>').show();
				$btn.prop('disabled', false).html('<span class="dashicons dashicons-dismiss"></span> <?php echo esc_js( __( 'Reject', 'respira-for-wordpress' ) ); ?>');
			}
		});
	});
	
	// Confetti library (canvas-confetti)
	if (typeof confetti === 'undefined') {
		var script = document.createElement('script');
		script.src = 'https://cdn.jsdelivr.net/npm/canvas-confetti@1.9.2/dist/confetti.browser.min.js';
		script.onload = function() {
			console.log('Confetti library loaded');
		};
		document.head.appendChild(script);
	}
	
	// Testimonial modal handlers
	$('.respira-modal-close, .respira-modal-overlay').on('click', function() {
		$('#respira-testimonial-modal').fadeOut(300);
		// Reload page after closing modal
		setTimeout(function() {
			location.reload();
		}, 300);
	});
	
	// Rating stars
	$('.respira-star-btn').on('click', function() {
		var rating = $(this).data('rating');
		$('#testimonial-rating').val(rating);
		$('.respira-star-btn').each(function() {
			var $btn = $(this);
			var btnRating = $btn.data('rating');
			var $icon = $btn.find('.dashicons');
			if (btnRating <= rating) {
				$icon.removeClass('dashicons-star-empty').addClass('dashicons-star-filled').css('color', '#fbbf24');
			} else {
				$icon.removeClass('dashicons-star-filled').addClass('dashicons-star-empty').css('color', '#6b7280');
			}
		});
	});
	
	// Testimonial form submission
	$('#respira-testimonial-form').on('submit', function(e) {
		e.preventDefault();
		var $form = $(this);
		var $message = $('#respira-testimonial-message');
		var $submitBtn = $form.find('button[type="submit"]');
		
		// Validate rating
		if (!$('#testimonial-rating').val()) {
			$message.removeClass('success').addClass('error').html('<?php echo esc_js( __( 'Please select a rating.', 'respira-for-wordpress' ) ); ?>').show();
			return;
		}
		
		$submitBtn.prop('disabled', true).text('<?php echo esc_js( __( 'Submitting...', 'respira-for-wordpress' ) ); ?>');
		
		$.ajax({
			url: respira_admin.ajax_url,
			type: 'POST',
			data: {
				action: 'respira_submit_testimonial',
				nonce: respira_admin.nonce,
				name: $('#testimonial-name').val(),
				testimonial: $('#testimonial-text').val(),
				rating: $('#testimonial-rating').val(),
				anonymous_name: $form.find('input[name="anonymous_name"]').is(':checked') ? 1 : 0,
				anonymous_website: $form.find('input[name="anonymous_website"]').is(':checked') ? 1 : 0,
				website_url: $form.find('input[name="website_url"]').val()
			},
			success: function(response) {
				if (response.success) {
					$message.removeClass('error').addClass('success').html('<span class="dashicons dashicons-yes-alt"></span> ' + (response.data.message || '<?php echo esc_js( __( 'Thank you for your testimonial!', 'respira-for-wordpress' ) ); ?>')).show();
					$form.hide();
					setTimeout(function() {
						$('#respira-testimonial-modal').fadeOut(300);
						location.reload();
					}, 2000);
				} else {
					$message.removeClass('success').addClass('error').html('<span class="dashicons dashicons-warning"></span> ' + (response.data.message || '<?php echo esc_js( __( 'An error occurred.', 'respira-for-wordpress' ) ); ?>')).show();
					$submitBtn.prop('disabled', false).text('<?php echo esc_js( __( 'Submit Testimonial', 'respira-for-wordpress' ) ); ?>');
				}
			},
			error: function() {
				$message.removeClass('success').addClass('error').html('<span class="dashicons dashicons-warning"></span> <?php echo esc_js( __( 'Network error. Please try again.', 'respira-for-wordpress' ) ); ?>').show();
				$submitBtn.prop('disabled', false).text('<?php echo esc_js( __( 'Submit Testimonial', 'respira-for-wordpress' ) ); ?>');
			}
		});
	});
});
</script>

	</div>

	<?php require_once RESPIRA_PLUGIN_DIR . 'admin/views/partials/footer.php'; ?>
</div>
