<?php
/**
 * API Keys view.
 *
 * @package    Respira_For_WordPress
 * @subpackage Respira_For_WordPress/admin/views
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$user_keys = Respira_Auth::get_user_keys( get_current_user_id() );
$new_key = get_transient( 'respira_new_api_key' );
if ( $new_key ) {
	delete_transient( 'respira_new_api_key' );
}

// Get license info for conditional display
$license_info = Respira_License::get_license_info();
$license_key = $license_info['key'];
$license_status = $license_info['status'];
?>

<div class="wrap respira-admin-page">
	<?php require_once RESPIRA_PLUGIN_DIR . 'admin/views/partials/header.php'; ?>
	<div class="respira-page-body">
		<?php settings_errors( 'respira_messages' ); ?>

		<?php if ( $new_key ) : ?>
			<div class="notice notice-success">
				<p><strong><?php esc_html_e( 'Your new API key:', 'respira-for-wordpress' ); ?></strong></p>
				<div class="respira-new-key">
					<code class="respira-api-key-display"><?php echo esc_html( $new_key ); ?></code>
					<button class="button button-primary respira-copy-btn" data-copy="<?php echo esc_attr( $new_key ); ?>">
						<?php esc_html_e( 'Copy Key', 'respira-for-wordpress' ); ?>
					</button>
				</div>
				<p class="description">
					<?php esc_html_e( 'Save this key securely. For security reasons, it will not be shown again.', 'respira-for-wordpress' ); ?>
				</p>
			</div>
		<?php endif; ?>

		<?php if ( ! empty( $license_key ) && ( 'active' === $license_status || 'trial' === $license_status ) ) : ?>
			<div class="respira-card">
				<h2><?php esc_html_e( 'Generate New API Key', 'respira-for-wordpress' ); ?></h2>
				<form method="post" action="">
					<?php wp_nonce_field( 'respira_generate_key' ); ?>
					<table class="form-table">
						<tr>
							<th scope="row">
								<label for="key_name"><?php esc_html_e( 'Key Name', 'respira-for-wordpress' ); ?></label>
							</th>
							<td>
								<input type="text" name="key_name" id="key_name" class="regular-text" placeholder="<?php esc_attr_e( 'e.g., My MCP Server', 'respira-for-wordpress' ); ?>">
								<p class="description"><?php esc_html_e( 'Optional. Give this key a name to help you remember what it\'s for.', 'respira-for-wordpress' ); ?></p>
							</td>
						</tr>
					</table>
					<p class="submit">
						<input type="submit" name="respira_generate_key" class="button button-primary" value="<?php esc_attr_e( 'Generate API Key', 'respira-for-wordpress' ); ?>">
					</p>
				</form>
				
				<div style="background: rgba(10, 147, 150, 0.1); border-left: 3px solid #0A9396; padding: 12px; margin-top: 20px; border-radius: 4px;">
					<p style="margin: 0; color: #9ca3af; font-size: 13px; line-height: 1.6;">
						<span style="color: #0dbdc1;">ℹ️</span> <strong style="color: #0dbdc1;"><?php esc_html_e( 'Privacy Note:', 'respira-for-wordpress' ); ?></strong>
						<?php esc_html_e( 'Usage statistics (pages updated, lines of code estimates) may be collected to help improve the product. Your actual content, code, and data are NEVER transmitted or stored on our servers.', 'respira-for-wordpress' ); ?>
						<a href="https://respira.press/privacy" target="_blank" style="color: #0dbdc1; text-decoration: underline;">
							<?php esc_html_e( 'Privacy Policy', 'respira-for-wordpress' ); ?>
						</a>
					</p>
				</div>
			</div>
		<?php endif; ?>

		<div class="respira-card">
			<h2><?php esc_html_e( 'Your API Keys', 'respira-for-wordpress' ); ?></h2>
			<?php if ( ! empty( $user_keys ) ) : ?>
				<div class="respira-table-wrapper">
					<table class="wp-list-table widefat fixed striped respira-table">
					<thead>
						<tr>
							<th><?php esc_html_e( 'Name', 'respira-for-wordpress' ); ?></th>
							<th><?php esc_html_e( 'Created', 'respira-for-wordpress' ); ?></th>
							<th><?php esc_html_e( 'Last Used', 'respira-for-wordpress' ); ?></th>
							<th><?php esc_html_e( 'Status', 'respira-for-wordpress' ); ?></th>
							<th><?php esc_html_e( 'Actions', 'respira-for-wordpress' ); ?></th>
						</tr>
					</thead>
					<tbody>
						<?php foreach ( $user_keys as $key ) : ?>
							<tr>
								<td><strong><?php echo esc_html( $key->name ?: __( '(Unnamed)', 'respira-for-wordpress' ) ); ?></strong></td>
								<td><?php echo esc_html( mysql2date( 'Y-m-d H:i', $key->created_at ) ); ?></td>
								<td>
									<?php
									if ( $key->last_used ) {
										echo esc_html( human_time_diff( strtotime( $key->last_used ), current_time( 'timestamp' ) ) . ' ago' );
									} else {
										esc_html_e( 'Never', 'respira-for-wordpress' );
									}
									?>
								</td>
								<td>
									<?php if ( $key->is_active ) : ?>
										<span class="respira-status-active"><?php esc_html_e( 'Active', 'respira-for-wordpress' ); ?></span>
									<?php else : ?>
										<span class="respira-status-revoked"><?php esc_html_e( 'Revoked', 'respira-for-wordpress' ); ?></span>
									<?php endif; ?>
								</td>
								<td>
									<?php if ( $key->is_active ) : ?>
										<form method="post" action="" style="display: inline;">
											<?php wp_nonce_field( 'respira_revoke_key' ); ?>
											<input type="hidden" name="key_id" value="<?php echo esc_attr( $key->id ); ?>">
											<button type="submit" name="respira_revoke_key" class="button button-small button-link-delete" onclick="return confirm('<?php esc_attr_e( 'Are you sure you want to revoke this API key?', 'respira-for-wordpress' ); ?>');">
												<?php esc_html_e( 'Revoke', 'respira-for-wordpress' ); ?>
											</button>
										</form>
									<?php endif; ?>
								</td>
							</tr>
						<?php endforeach; ?>
					</tbody>
				</table>
			</div>
			<?php else : ?>
				<p><?php esc_html_e( 'No API keys yet. Generate one above to get started.', 'respira-for-wordpress' ); ?></p>
			<?php endif; ?>
		</div>
	</div>

	</div>

	<?php require_once RESPIRA_PLUGIN_DIR . 'admin/views/partials/footer.php'; ?>
</div>
